/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.ActionContent;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class Action
implements Parcelable {
    public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

        public Action createFromParcel(Parcel source) {
            return new Action(source);
        }

        public Action[] newArray(int size) {
            return new Action[size];
        }
    };
    private UUID id;
    private Type type;
    private Proximity proximity;
    private String url;
    private ActionContent content;
    private List<String> deviceUniqueIds;

    public static Builder builder() {
        return new Builder();
    }

    private Action() {
        this(new Builder());
    }

    private Action(Builder builder) {
        this.id = builder.id;
        this.type = builder.actionType;
        this.proximity = builder.proximity;
        this.url = builder.url;
        this.content = builder.content;
        this.deviceUniqueIds = builder.deviceUniqueIds;
    }

    protected Action(Parcel in) {
        this.id = (UUID)in.readSerializable();
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : Type.values()[tmpType];
        int tmpProximity = in.readInt();
        this.proximity = tmpProximity == -1 ? null : Proximity.values()[tmpProximity];
        this.url = in.readString();
        this.content = (ActionContent)in.readParcelable(ActionContent.class.getClassLoader());
        this.deviceUniqueIds = in.createStringArrayList();
    }

    public UUID getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public Proximity getProximity() {
        return this.proximity;
    }

    public String getUrl() {
        if (this.type == Type.CONTENT) {
            return null;
        }
        return this.url;
    }

    public ActionContent getContent() {
        if (this.type == Type.BROWSER) {
            return null;
        }
        return this.content;
    }

    public List<String> getDeviceUniqueIds() {
        return this.deviceUniqueIds;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Action)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Action other = (Action)o;
        return SDKEqualsBuilder.start().equals(this.id, other.id).equals((Object)this.type, (Object)other.type).equals((Object)this.proximity, (Object)other.proximity).equals(this.url, other.url).equals(this.content, other.content).equals(this.deviceUniqueIds, other.deviceUniqueIds).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.id).append((Object)this.type).append((Object)this.proximity).append(this.url).append(this.content).append(this.deviceUniqueIds).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.id);
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeInt(this.proximity == null ? -1 : this.proximity.ordinal());
        dest.writeString(this.url);
        dest.writeParcelable((Parcelable)this.content, flags);
        dest.writeStringList(this.deviceUniqueIds);
    }

    public static class Builder {
        private UUID id;
        private Type actionType;
        private Proximity proximity;
        private String url;
        private ActionContent content;
        private List<String> deviceUniqueIds;

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder actionType(Type actionType) {
            this.actionType = actionType;
            return this;
        }

        public Builder proximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder content(ActionContent content) {
            this.content = content;
            return this;
        }

        public Builder devices(List<String> deviceUniqueIds) {
            this.deviceUniqueIds = deviceUniqueIds;
            return this;
        }

        public Action build() {
            return new Action(this);
        }
    }

    public static enum Type {
        BROWSER,
        CONTENT;

    }
}

