/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.venues;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class UnshareVenueRequestExecutor
extends RequestExecutor<String> {
    private final VenuesService venuesService;
    private final UUID[] ids;
    private String[] managerEmails;

    public UnshareVenueRequestExecutor(VenuesService venuesService, UUID ... ids) {
        this.venuesService = venuesService;
        this.ids = ids;
    }

    public UnshareVenueRequestExecutor(VenuesService venuesService, List<UUID> ids) {
        this.venuesService = venuesService;
        int size = ids.size();
        this.ids = ids.toArray(new UUID[size]);
    }

    public UnshareVenueRequestExecutor fromManagers(String ... managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        this.managerEmails = managerEmails;
        return this;
    }

    public UnshareVenueRequestExecutor fromManagers(List<String> managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        int size = managerEmails.size();
        this.managerEmails = managerEmails.toArray(new String[size]);
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.venuesService.unshareVenue(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.managerEmails != null, "cannot unshare venue - specify managers");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("venueId", StringUtils.join(this.ids, ","));
        params.put("managerMail", StringUtils.join(this.managerEmails, ","));
        return params;
    }
}

