/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.namespaces;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.NamespacesService;
import com.kontakt.sdk.android.cloud.response.paginated.Namespaces;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Map;
import retrofit2.Call;

public class NamespacesRequestExecutor
extends PaginatedRequestExecutor<Namespaces> {
    private final NamespacesService namespacesService;
    private String mappedBy;

    public NamespacesRequestExecutor(NamespacesService namespacesService) {
        this.namespacesService = namespacesService;
    }

    public NamespacesRequestExecutor mappedBy(String namespace) {
        SDKPreconditions.checkNotNull(namespace, "namespace cannot be null");
        this.mappedBy = namespace;
        return this;
    }

    @Override
    public NamespacesRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public NamespacesRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public NamespacesRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public NamespacesRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public NamespacesRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Namespaces> prepareCall() {
        Call<Namespaces> call = this.eTag != null ? this.namespacesService.getNamespaces(this.params(), this.eTag) : this.namespacesService.getNamespaces(this.params());
        return call;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.mappedBy != null) {
            params.put("namespace", this.mappedBy);
        }
        return params;
    }
}

