/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.managers;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ManagersService;
import com.kontakt.sdk.android.cloud.response.paginated.Managers;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;
import retrofit2.Call;

public class ManagersRequestExecutor
extends PaginatedRequestExecutor<Managers> {
    private final ManagersService managersService;
    private UUID managerId;

    public ManagersRequestExecutor(ManagersService managersService) {
        this.managersService = managersService;
    }

    public ManagersRequestExecutor subordinatesOf(UUID managerId) {
        SDKPreconditions.checkNotNull(managerId, "manager ID cannot be null");
        this.managerId = managerId;
        return this;
    }

    @Override
    public ManagersRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public ManagersRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public ManagersRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public ManagersRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public ManagersRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Managers> prepareCall() {
        Call<Managers> call = this.eTag != null ? (this.managerId != null ? this.managersService.getManagerSubOrdinates(this.managerId.toString(), this.params(), this.eTag) : this.managersService.getManagers(this.params(), this.eTag)) : (this.managerId != null ? this.managersService.getManagerSubOrdinates(this.managerId.toString(), this.params()) : this.managersService.getManagers(this.params()));
        return call;
    }
}

