/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.firmwares;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.paginated.Firmwares;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.FirmwareType;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import retrofit2.Call;

public class FirmwaresRequestExecutor
extends PaginatedRequestExecutor<Firmwares> {
    private final FirmwaresService firmwaresService;
    private String[] deviceUniqueIds;
    private FirmwareType type;

    public FirmwaresRequestExecutor(FirmwaresService firmwaresService) {
        this.firmwaresService = firmwaresService;
    }

    public FirmwaresRequestExecutor forDevices(String ... uniqueIds) {
        this.deviceUniqueIds = SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return this;
    }

    public FirmwaresRequestExecutor forDevices(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.deviceUniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    public FirmwaresRequestExecutor forDevices(Set<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.deviceUniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    public FirmwaresRequestExecutor withType(FirmwareType type) {
        SDKPreconditions.checkNotNull(type, "type cannot be null");
        this.type = type;
        return this;
    }

    @Override
    public FirmwaresRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public FirmwaresRequestExecutor maxResult(int maxResult) {
        super.startIndex(maxResult);
        return this;
    }

    @Override
    public FirmwaresRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public FirmwaresRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public FirmwaresRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    public Firmwares execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Firmwares)super.execute();
    }

    @Override
    public void execute(CloudCallback<Firmwares> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Firmwares> prepareCall() {
        Call<Firmwares> call = this.eTag != null ? this.firmwaresService.getFirmwares(this.params(), this.eTag) : this.firmwaresService.getFirmwares(this.params());
        return call;
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.deviceUniqueIds != null, "cannot get firmwares - specify device IDs");
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.deviceUniqueIds != null) {
            params.put("uniqueId", StringUtils.join(this.deviceUniqueIds, ","));
        }
        if (this.type != null) {
            params.put("type", this.type.name());
        }
        return params;
    }
}

