/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.firmwares;

import com.kontakt.sdk.android.cloud.api.executor.FileRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.FileData;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;

public class FirmwareFileRequestExecutor
extends FileRequestExecutor {
    private final FirmwaresService firmwaresService;
    private final String name;
    private final Model model;
    private DeviceType deviceType;

    public FirmwareFileRequestExecutor(FirmwaresService firmwaresService, String name, Model model) {
        this.firmwaresService = firmwaresService;
        this.name = name;
        this.model = model;
    }

    public FirmwareFileRequestExecutor forDeviceType(DeviceType deviceType) {
        SDKPreconditions.checkNotNull(deviceType, "device type cannot be null");
        this.deviceType = deviceType;
        return this;
    }

    @Override
    public FileData execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return super.execute();
    }

    @Override
    public void execute(CloudCallback<FileData> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.deviceType != null, "cannot get firmware - specify device type");
    }

    @Override
    protected Call<ResponseBody> prepareCall() {
        return this.firmwaresService.getFirmwareFile(this.name, this.model.name().toLowerCase(), this.deviceType.name());
    }
}

