/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;
import java.util.UUID;

abstract class DevicesBaseRequestExecutor
extends PaginatedRequestExecutor<Devices> {
    protected Access access;
    protected DeviceProfile profile;
    protected DeviceType type;
    protected UUID[] managerIds;

    DevicesBaseRequestExecutor() {
    }

    public DevicesBaseRequestExecutor access(Access access) {
        this.access = SDKPreconditions.checkNotNull(access, "access cannot be null");
        return this;
    }

    public DevicesBaseRequestExecutor managerIds(UUID ... managerIds) {
        this.managerIds = SDKPreconditions.checkNotNull(managerIds, "manager IDs cannot be null");
        return this;
    }

    public DevicesBaseRequestExecutor managerIds(List<UUID> managerIds) {
        SDKPreconditions.checkNotNull(managerIds, "manager IDs cannot be null");
        int size = managerIds.size();
        this.managerIds = managerIds.toArray(new UUID[size]);
        return this;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.access != null) {
            params.put("access", this.access.name());
        }
        if (this.profile != null) {
            params.put("profile", this.profile.name());
        }
        if (this.type != null) {
            params.put("deviceType", this.type.name());
        }
        if (this.managerIds != null) {
            params.put("managerId", StringUtils.join(this.managerIds, ","));
        }
        return params;
    }
}

