/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.configs.ConfigsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.configs.CreateConfigRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.configs.DeletePendingConfigsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.configs.SecureConfigsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ConfigsService;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;

public class ConfigsApi {
    private final ConfigsService configsService;

    public ConfigsApi(ConfigsService configsService) {
        this.configsService = configsService;
    }

    public ConfigsRequestExecutor fetch() {
        return new ConfigsRequestExecutor(this.configsService);
    }

    public SecureConfigsRequestExecutor secure() {
        return new SecureConfigsRequestExecutor(this.configsService);
    }

    public CreateConfigRequestExecutor create(Config config) {
        SDKPreconditions.checkNotNull(config, "config cannot be null");
        return new CreateConfigRequestExecutor(this.configsService, config);
    }

    public DeletePendingConfigsRequestExecutor delete(String ... uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new DeletePendingConfigsRequestExecutor(this.configsService, uniqueIds);
    }

    public DeletePendingConfigsRequestExecutor delete(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new DeletePendingConfigsRequestExecutor(this.configsService, uniqueIds);
    }
}

