/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.cloud.adapter.BaseTypeAdapter;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.PacketType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ConfigTypeAdapter
extends BaseTypeAdapter<Config> {
    public void write(JsonWriter out, Config config) throws IOException {
        this.writeUUID(out, "proximity", config.getProximity());
        this.writeInteger(out, "major", config.getMajor());
        this.writeInteger(out, "minor", config.getMinor());
        this.writeInteger(out, "txPower", config.getTxPower());
        this.writeInteger(out, "interval", config.getInterval());
        this.writeString(out, "namespace", config.getNamespace());
        this.writeString(out, "instanceId", config.getInstanceId());
        String url = config.getUrl();
        if (url != null) {
            String encodedUrl = EddystoneUtils.toHexString(EddystoneUtils.serializeUrl(url));
            this.writeString(out, "url", encodedUrl);
        }
        this.writeProfiles(out, config.getProfiles());
        this.writePackets(out, config.getPackets());
        this.writeBoolean(out, "shuffled", config.isShuffled());
        this.writeString(out, "name", config.getName());
        this.writeString(out, "password", config.getPassword());
        this.writeString(out, "config", config.getSecureRequest());
        this.writeString(out, "response", config.getSecureResponse());
        this.writeLong(out, "updated", config.getSecureResponseTime());
    }

    public Config read(JsonReader in) throws IOException {
        Config.Builder configBuilder = new Config.Builder();
        in.beginObject();
        block34: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "uniqueId": {
                    String uniqueId = in.nextString();
                    configBuilder.uniqueId(uniqueId);
                    continue block34;
                }
                case "proximity": {
                    UUID proximity = UUID.fromString(in.nextString());
                    configBuilder.proximity(proximity);
                    continue block34;
                }
                case "major": {
                    int major = in.nextInt();
                    configBuilder.major(major);
                    continue block34;
                }
                case "minor": {
                    int minor = in.nextInt();
                    configBuilder.minor(minor);
                    continue block34;
                }
                case "txPower": {
                    int txPower = in.nextInt();
                    configBuilder.txPower(txPower);
                    continue block34;
                }
                case "interval": {
                    int interval = in.nextInt();
                    configBuilder.interval(interval);
                    continue block34;
                }
                case "namespace": {
                    String namespace = in.nextString();
                    configBuilder.namespace(namespace);
                    continue block34;
                }
                case "url": {
                    String url = in.nextString();
                    configBuilder.url(url);
                    continue block34;
                }
                case "instanceId": {
                    String instanceId = in.nextString();
                    configBuilder.instanceId(instanceId);
                    continue block34;
                }
                case "profiles": {
                    List<DeviceProfile> profiles = this.readProfiles(in);
                    configBuilder.profiles(profiles);
                    continue block34;
                }
                case "packets": {
                    List<PacketType> packets = this.readPackets(in);
                    configBuilder.packets(packets);
                    continue block34;
                }
                case "shuffled": {
                    boolean shuffled = in.nextBoolean();
                    configBuilder.shuffled(shuffled);
                    continue block34;
                }
                case "name": {
                    String name = in.nextString();
                    configBuilder.name(name);
                    continue block34;
                }
                case "password": {
                    String password = in.nextString();
                    configBuilder.password(password);
                    continue block34;
                }
                case "config": {
                    String secureRequest = in.nextString();
                    configBuilder.secureRequest(secureRequest);
                    continue block34;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return configBuilder.build();
    }

    private void writeProfiles(JsonWriter out, List<DeviceProfile> profiles) throws IOException {
        out.name("profiles");
        if (profiles == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (DeviceProfile profile : profiles) {
            out.value(profile.name());
        }
        out.endArray();
    }

    private void writePackets(JsonWriter out, List<PacketType> packets) throws IOException {
        out.name("packets");
        if (packets == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (PacketType packet : packets) {
            out.value(packet.name());
        }
        out.endArray();
    }

    List<DeviceProfile> readProfiles(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<DeviceProfile> profiles = new ArrayList<DeviceProfile>();
        while (in.hasNext()) {
            profiles.add(DeviceProfile.valueOf(in.nextString()));
        }
        in.endArray();
        return profiles;
    }

    List<PacketType> readPackets(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<PacketType> packets = new ArrayList<PacketType>();
        while (in.hasNext()) {
            packets.add(PacketType.valueOf(in.nextString()));
        }
        in.endArray();
        return packets;
    }
}

