/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import android.annotation.TargetApi;
import android.util.SparseLongArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@TargetApi(value=18)
public class SafeSparseLongArray
extends SparseLongArray {
    private final Lock writeLock;
    private final Lock readLock;

    public SafeSparseLongArray() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.writeLock = readWriteLock.writeLock();
        this.readLock = readWriteLock.readLock();
    }

    public SafeSparseLongArray(int initialCapacity) {
        super(initialCapacity);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.writeLock = readWriteLock.writeLock();
        this.readLock = readWriteLock.readLock();
    }

    public SparseLongArray clone() {
        try {
            this.readLock.lock();
            SparseLongArray sparseLongArray = super.clone();
            return sparseLongArray;
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(int key, long valueIfKeyNotFound) {
        try {
            this.readLock.lock();
            long l = super.get(key, valueIfKeyNotFound);
            return l;
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.readLock);
        }
    }

    public void delete(int key) {
        try {
            this.writeLock.lock();
            super.delete(key);
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.writeLock);
        }
    }

    public void removeAt(int index) {
        try {
            this.writeLock.lock();
            super.removeAt(index);
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int key, long value) {
        try {
            this.writeLock.lock();
            super.put(key, value);
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.writeLock);
        }
    }

    public int size() {
        try {
            this.readLock.lock();
            int n = super.size();
            return n;
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.readLock);
        }
    }

    public int keyAt(int index) {
        try {
            this.readLock.lock();
            int n = super.keyAt(index);
            return n;
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long valueAt(int index) {
        try {
            this.readLock.lock();
            long l = super.valueAt(index);
            return l;
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.readLock);
        }
    }

    public int indexOfKey(int key) {
        try {
            this.readLock.lock();
            int n = super.indexOfKey(key);
            return n;
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOfValue(long value) {
        try {
            this.readLock.lock();
            int n = super.indexOfValue(value);
            return n;
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.readLock);
        }
    }

    public void clear() {
        try {
            this.writeLock.lock();
            super.clear();
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(int key, long value) {
        try {
            this.writeLock.lock();
            super.append(key, value);
        }
        finally {
            SafeSparseLongArray.unlockSafely(this.writeLock);
        }
    }

    private static void unlockSafely(Lock lock) {
        try {
            lock.unlock();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

