/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.ScanCompat;
import com.kontakt.sdk.android.ble.service.ScanCompatFactory;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanContextAccessor;
import com.kontakt.sdk.android.ble.service.ScanController;
import com.kontakt.sdk.android.ble.service.ServiceScanConfiguration;
import com.kontakt.sdk.android.common.interfaces.SDKSupplier;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.Closeables;
import java.io.Closeable;
import java.io.IOException;

public class ProximityService
extends Service
implements ScanContextAccessor {
    private static final String TAG = ProximityService.class.getSimpleName();
    public static final int MESSAGE_RESTART_SCAN = 3;
    public static final int MESSAGE_INITIALIZE_SCAN = 4;
    public static final int MESSAGE_FINISH_SCAN = 5;
    public static final int MESSAGE_ATTACH_MONITORING_LISTENER = 6;
    public static final int MESSAGE_DETACH_MONITORING_LISTENER = 7;
    public static final int MESSAGE_WORK_FINISHED = 8;
    public static final int MESSAGE_SERVICE_RESPONSE_OK = 201;
    private final ServiceScanConfiguration configuration = new ServiceScanConfiguration();
    private Messenger serviceMessenger;
    private ServiceBinder serviceBinder;
    private Handler messagingHandler;
    private ScanCompat scanCompat;

    public void onCreate() {
        super.onCreate();
        this.messagingHandler = new MessagingHandler(this);
        this.serviceMessenger = new Messenger(this.messagingHandler);
        this.serviceBinder = new ServiceBinder(this.serviceMessenger);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return this.serviceBinder;
    }

    public void onDestroy() {
        super.onDestroy();
        this.configuration.clear();
        this.messagingHandler = null;
        this.serviceMessenger = null;
    }

    @Override
    public ScanContext getScanContext(int proximityManagerId) {
        return this.configuration.getScanContext(proximityManagerId);
    }

    public final Handler getMessagingHandler() {
        return this.messagingHandler;
    }

    ServiceScanConfiguration getConfiguration() {
        return this.configuration;
    }

    private void onStartScan(ScanContext scanContext, boolean forceConfigurationRebuild, int proximityManagerId) {
        boolean isNewScanContextRequested = scanContext != this.configuration.getScanContext(proximityManagerId) && !this.isScanning(proximityManagerId);
        this.createScanCompat();
        if (forceConfigurationRebuild || isNewScanContextRequested) {
            this.onStopScan(proximityManagerId);
            ScanConfiguration previousConfiguration = this.configuration.getScanConfiguration(proximityManagerId);
            ScanConfiguration newConfiguration = this.scanCompat.createScanConfiguration(previousConfiguration.getScanCallback(), scanContext, this.serviceMessenger);
            ProximityService.ensureClosed(previousConfiguration);
            ForceScanScheduler forceScanScheduler = this.scanCompat.createForceScanScheduler(newConfiguration);
            ScanController scanController = this.scanCompat.createScanController(newConfiguration, forceScanScheduler);
            ServiceScanConfiguration.Item item = new ServiceScanConfiguration.Item(scanContext, newConfiguration, forceScanScheduler, scanController);
            this.configuration.add(proximityManagerId, item);
        }
        this.configuration.getScanController(proximityManagerId).start();
        this.scanCompat.onScanStart(this.configuration.getScanConfiguration(proximityManagerId));
        this.updateState(proximityManagerId, State.SCANNING);
    }

    private void onStopScan(int proximityManagerId) {
        if (this.isScanning(proximityManagerId)) {
            this.createScanCompat();
            this.configuration.getScanController(proximityManagerId).stop();
            this.scanCompat.onScanStop(this.configuration.getScanConfiguration(proximityManagerId).getScanCallback());
            this.configuration.getForceScanScheduler(proximityManagerId).stop();
            this.updateState(proximityManagerId, State.IDLE);
        } else {
            Logger.d(TAG + ": Stop Ranging method requested but BeaconService is not is Ranging state.");
        }
    }

    private void onAttachListener(int proximityManagerId, InternalProximityListener proximityListener) {
        this.configuration.addListener(proximityManagerId, proximityListener);
    }

    private void onDetachListener(int proximityManagerId, InternalProximityListener proximityListener) {
        this.configuration.removeListener(proximityManagerId, proximityListener);
    }

    protected boolean isScanning(int proximityManagerId) {
        return this.configuration.getState(proximityManagerId) == State.SCANNING;
    }

    protected void updateState(int proximityManagerId, State newState) {
        this.configuration.updateState(proximityManagerId, newState);
    }

    private void onCleanUp(int proximityManagerId) {
        ServiceScanConfiguration.Item item = this.configuration.remove(proximityManagerId);
        ProximityService.ensureClosed(item.scanConfiguration);
        ForceScanScheduler forceScanScheduler = item.forceScanScheduler;
        if (forceScanScheduler != null) {
            forceScanScheduler.finish();
        }
        item.scanController.stop();
    }

    private void createScanCompat() {
        if (this.scanCompat == null) {
            this.scanCompat = ScanCompatFactory.createScanCompat();
        }
    }

    private static void ensureClosed(Closeable closeable) {
        try {
            Closeables.close(closeable, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static enum State {
        IDLE,
        SCANNING;

    }

    private static class MessagingHandler
    extends Handler {
        private ProximityService service;

        private MessagingHandler(ProximityService abstractBluetoothDeviceService) {
            this.service = abstractBluetoothDeviceService;
        }

        public void handleMessage(Message msg) {
            try {
                int proximityManagerId = msg.arg1;
                switch (msg.what) {
                    case 4: {
                        Logger.d(TAG + ": Message received - start ranging");
                        this.service.onStartScan((ScanContext)msg.obj, true, proximityManagerId);
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)201, (int)0));
                        break;
                    }
                    case 5: {
                        Logger.d(TAG + ": Message received - stop ranging");
                        this.service.onStopScan(proximityManagerId);
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)201, (int)0));
                        break;
                    }
                    case 3: {
                        Logger.d(TAG + ": Message received - restart ranging");
                        this.service.onStopScan(proximityManagerId);
                        this.service.onStartScan((ScanContext)msg.obj, true, proximityManagerId);
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)201, (int)0));
                        break;
                    }
                    case 8: {
                        Logger.d(TAG + ": Message received - work finished");
                        this.service.onCleanUp(proximityManagerId);
                        this.service.stopSelf();
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)201, (int)0));
                        break;
                    }
                    case 6: {
                        Logger.d(TAG + ": Attaching listener");
                        this.service.onAttachListener(proximityManagerId, (InternalProximityListener)msg.obj);
                        break;
                    }
                    case 7: {
                        Logger.d(TAG + ": Detaching listener");
                        this.service.onDetachListener(proximityManagerId, (InternalProximityListener)msg.obj);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported message code: " + msg.what);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ServiceBinder
    extends Binder
    implements SDKSupplier<Messenger> {
        private final Messenger serviceMessenger;

        private ServiceBinder(Messenger serviceMessenger) {
            this.serviceMessenger = serviceMessenger;
        }

        @Override
        public Messenger get() {
            return this.serviceMessenger;
        }
    }
}

