/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.service;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import com.kontakt.sdk.android.ble.manager.service.ServiceConnector;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public abstract class AbstractServiceConnector
implements ServiceConnector {
    private final String[] permissions;
    private final String[] permissionsMarshmallow;
    protected Context context;

    protected AbstractServiceConnector(Context context, String[] permissions, String[] permissionsMarshmallow) {
        SDKPreconditions.checkState(context != null, "Applied context instance is null");
        SDKPreconditions.checkState(permissions != null, "Permissions not specified");
        this.context = context.getApplicationContext();
        this.permissions = permissions;
        this.permissionsMarshmallow = permissionsMarshmallow;
    }

    @Override
    public void disconnect() {
        Logger.d(this.getClass().getSimpleName() + " disconnected.");
    }

    @TargetApi(value=15)
    protected void checkPermissions() {
        this.checkStandardPermissions();
        this.checkMarshmallowPermissions();
    }

    private void checkStandardPermissions() {
        for (String permission2 : this.permissions) {
            if (this.context.checkCallingOrSelfPermission(permission2) == 0) continue;
            throw new RuntimeException(String.format("Permission %s is not granted", permission2));
        }
    }

    private void checkMarshmallowPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            for (String permission2 : this.permissionsMarshmallow) {
                if (this.context.checkCallingOrSelfPermission(permission2) != 0) continue;
                return;
            }
            throw new RuntimeException(String.format("Permission ACCESS_COARSE_LOCATION or ACCESS_FINE_LOCATION must be granted for android Marshmallow", new Object[0]));
        }
    }
}

