/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.internal;

import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.internal.SpacesResolver;
import com.kontakt.sdk.android.ble.util.ScanContextUtils;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class ShuffledSpacesManager {
    private final List<SpacesResolver> resolvers = new ArrayList<SpacesResolver>();
    private OnSpacesResolvedListener onSpacesResolvedListener;
    private ScanContext scanContext;
    private final SpacesResolver.ResolvingStatusListener resolvingStatusListener = new SpacesResolver.ResolvingStatusListener(){

        @Override
        public void onSuccess() {
            if (ShuffledSpacesManager.this.allResolversAreFinishedSuccessfully()) {
                Collection regions = ((SpacesResolver)ShuffledSpacesManager.this.resolvers.get(0)).getResolvedSpaces();
                Collection namespaces = ((SpacesResolver)ShuffledSpacesManager.this.resolvers.get(1)).getResolvedSpaces();
                ShuffledSpacesManager.this.resetFinishedStatus();
                ShuffledSpacesManager.this.onSpacesResolvedListener.onSpacesResolved(ShuffledSpacesManager.this.createScanContext(regions, namespaces));
            }
        }

        @Override
        public void onError(String message) {
            ShuffledSpacesManager.this.onSpacesResolvedListener.onError(new ScanError(message));
        }
    };

    public ShuffledSpacesManager(IKontaktCloud cloud) {
        this.resolvers.add(new SpacesResolver.RegionsResolver(cloud));
        this.resolvers.add(new SpacesResolver.NamespacesResolver(cloud));
    }

    public void resolve(ScanContext scanContext, OnSpacesResolvedListener onSpacesResolvedListener) {
        this.scanContext = SDKPreconditions.checkNotNull(scanContext);
        this.onSpacesResolvedListener = SDKPreconditions.checkNotNull(onSpacesResolvedListener);
        for (SpacesResolver resolver : this.resolvers) {
            resolver.resolve(scanContext, this.resolvingStatusListener);
        }
    }

    public void clearCache() {
        for (SpacesResolver resolver : this.resolvers) {
            resolver.clearCache();
        }
    }

    public void onDestroy() {
        this.onSpacesResolvedListener = null;
    }

    private ScanContext createScanContext(Collection<IBeaconRegion> resolvedRegions, Collection<IEddystoneNamespace> resolvedNamespaces) {
        return ScanContextUtils.cloneWithNewSpaces(this.scanContext, resolvedRegions, resolvedNamespaces);
    }

    private void resetFinishedStatus() {
        for (SpacesResolver resolver : this.resolvers) {
            resolver.resetFinishedStatus();
        }
    }

    private boolean allResolversAreFinishedSuccessfully() {
        for (SpacesResolver resolver : this.resolvers) {
            if (resolver.isFinishedSuccessfully()) continue;
            return false;
        }
        return true;
    }

    static interface OnSpacesResolvedListener {
        public void onSpacesResolved(ScanContext var1);

        public void onError(ScanError var1);
    }
}

