/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.internal;

import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.listeners.EddystoneListener;
import com.kontakt.sdk.android.ble.manager.listeners.IBeaconListener;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.manager.listeners.ScanStatusListener;
import com.kontakt.sdk.android.ble.manager.listeners.SpaceListener;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import java.util.List;

public class EventObserver
implements InternalProximityListener {
    private final ScanStatusListener scanStatusListener;
    private final SpaceListener spaceListener;
    private final EddystoneListener eddystoneListener;
    private final IBeaconListener iBeaconListener;

    public EventObserver(EddystoneListener eddystoneListener, IBeaconListener iBeaconListener, ScanStatusListener scanStatusListener, SpaceListener spaceListener) {
        this.iBeaconListener = iBeaconListener;
        this.eddystoneListener = eddystoneListener;
        this.scanStatusListener = scanStatusListener;
        this.spaceListener = spaceListener;
    }

    @Override
    public void onScanStart() {
        if (this.scanStatusListener != null) {
            this.scanStatusListener.onScanStart();
        }
    }

    @Override
    public void onScanStop() {
        if (this.scanStatusListener != null) {
            this.scanStatusListener.onScanStop();
        }
    }

    @Override
    public void onMonitoringCycleStart() {
        if (this.scanStatusListener != null) {
            this.scanStatusListener.onMonitoringCycleStart();
        }
    }

    @Override
    public void onMonitoringCycleStop() {
        if (this.scanStatusListener != null) {
            this.scanStatusListener.onMonitoringCycleStop();
        }
    }

    @Override
    public void onScanError(ScanError exception) {
        if (this.scanStatusListener != null) {
            this.scanStatusListener.onScanError(exception);
        }
    }

    @Override
    public void onEvent(BluetoothDeviceEvent event) {
        if (this.eddystoneListener != null && event instanceof EddystoneDeviceEvent) {
            this.onEddystoneEvent((EddystoneDeviceEvent)event);
        } else if (this.iBeaconListener != null && event instanceof IBeaconDeviceEvent) {
            this.onIBeaconEvent((IBeaconDeviceEvent)event);
        }
    }

    private void onEddystoneEvent(EddystoneDeviceEvent event) {
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: 
            case DEVICES_UPDATE: 
            case DEVICE_LOST: {
                this.invokeDeviceCallbacks(event);
                break;
            }
            case SPACE_ENTERED: 
            case SPACE_ABANDONED: {
                this.invokeSpaceCallbacks(event);
            }
        }
    }

    private void onIBeaconEvent(IBeaconDeviceEvent event) {
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: 
            case DEVICES_UPDATE: 
            case DEVICE_LOST: {
                this.invokeDeviceCallbacks(event);
                break;
            }
            case SPACE_ENTERED: 
            case SPACE_ABANDONED: {
                this.invokeSpaceCallbacks(event);
            }
        }
    }

    private void invokeDeviceCallbacks(EddystoneDeviceEvent event) {
        List<IEddystoneDevice> deviceList = event.getDeviceList();
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: {
                this.eddystoneListener.onEddystoneDiscovered(deviceList.get(0), event.getNamespace());
                break;
            }
            case DEVICES_UPDATE: {
                this.eddystoneListener.onEddystonesUpdated(deviceList, event.getNamespace());
                break;
            }
            case DEVICE_LOST: {
                this.eddystoneListener.onEddystoneLost(deviceList.get(0), event.getNamespace());
            }
        }
    }

    private void invokeDeviceCallbacks(IBeaconDeviceEvent event) {
        List<IBeaconDevice> deviceList = event.getDeviceList();
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: {
                this.iBeaconListener.onIBeaconDiscovered(deviceList.get(0), event.getRegion());
                break;
            }
            case DEVICES_UPDATE: {
                this.iBeaconListener.onIBeaconsUpdated(deviceList, event.getRegion());
                break;
            }
            case DEVICE_LOST: {
                this.iBeaconListener.onIBeaconLost(deviceList.get(0), event.getRegion());
            }
        }
    }

    private void invokeSpaceCallbacks(EddystoneDeviceEvent event) {
        if (this.spaceListener == null) {
            return;
        }
        switch (event.getEventType()) {
            case SPACE_ENTERED: {
                this.spaceListener.onNamespaceEntered(event.getNamespace());
                break;
            }
            case SPACE_ABANDONED: {
                this.spaceListener.onNamespaceAbandoned(event.getNamespace());
            }
        }
    }

    private void invokeSpaceCallbacks(IBeaconDeviceEvent event) {
        if (this.spaceListener == null) {
            return;
        }
        switch (event.getEventType()) {
            case SPACE_ENTERED: {
                this.spaceListener.onRegionEntered(event.getRegion());
                break;
            }
            case SPACE_ABANDONED: {
                this.spaceListener.onRegionAbandoned(event.getRegion());
            }
        }
    }
}

