/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.filter.ibeacon;

import android.text.TextUtils;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.IBeaconPropertyValidator;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public final class IBeaconMultiFilter
implements IBeaconFilter {
    public static final int NO_MAJOR = 0;
    public static final int NO_MINOR = 0;
    private final String deviceName;
    private final String address;
    private final UUID proximityUUID;
    private final String beaconUniqueId;
    private final String firmware;
    private final int major;
    private final int minor;

    public IBeaconMultiFilter(Builder builder) {
        this.deviceName = builder.deviceName;
        this.address = builder.address;
        this.proximityUUID = builder.proximityUUID;
        this.beaconUniqueId = builder.beaconUniqueId;
        this.firmware = builder.firmware;
        this.major = builder.major;
        this.minor = builder.minor;
    }

    public boolean apply(IBeaconDevice target) {
        if (!TextUtils.isEmpty((CharSequence)this.deviceName) && !this.deviceName.equals(target.getName())) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)this.address) && !this.address.equals(target.getAddress())) {
            return false;
        }
        if (this.proximityUUID != null && !this.proximityUUID.equals(target.getProximityUUID())) {
            return false;
        }
        String uniqueId = target.getUniqueId();
        if (!(TextUtils.isEmpty((CharSequence)this.beaconUniqueId) || TextUtils.isEmpty((CharSequence)uniqueId) || this.beaconUniqueId.equals(uniqueId))) {
            return false;
        }
        if (!this.firmware.equals(target.getFirmwareVersion())) {
            return false;
        }
        if (this.minor != 0 && this.minor != target.getMinor()) {
            return false;
        }
        return this.major == 0 || this.major == target.getMajor();
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getAddress() {
        return this.address;
    }

    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    public String getBeaconUniqueId() {
        return this.beaconUniqueId;
    }

    public String getFirmwareVersion() {
        return this.firmware;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public static class Builder {
        private String deviceName = null;
        private String address = null;
        private UUID proximityUUID = null;
        private String beaconUniqueId = null;
        private String firmware = "-1";
        private int major = 0;
        private int minor = 0;

        Builder() {
        }

        public Builder setDeviceName(String deviceName) {
            SDKPreconditions.checkNotNull(deviceName, "Device name cannot be null.");
            this.deviceName = deviceName;
            return this;
        }

        public Builder setAddress(String address) {
            SDKPreconditions.checkNotNull(address, "Address cannot be null.");
            this.address = address;
            return this;
        }

        public Builder setProximityUUID(UUID proximityUUID) {
            SDKPreconditions.checkNotNull(proximityUUID, "Proximity UUID cannot be null.");
            this.proximityUUID = proximityUUID;
            return this;
        }

        public Builder setBeaconUniqueId(String beaconUniqueId) {
            SDKPreconditions.checkNotNull(beaconUniqueId, "Beacon unique Id is null.");
            this.beaconUniqueId = beaconUniqueId;
            return this;
        }

        public Builder setFirmware(String firmware) {
            SDKPreconditions.checkNotNull(firmware, "Firmware is null.");
            this.firmware = firmware;
            return this;
        }

        public Builder setMinor(int minor) {
            IBeaconPropertyValidator.validateMinor(minor);
            this.minor = minor;
            return this;
        }

        public Builder setMajor(int major) {
            IBeaconPropertyValidator.validateMajor(this.minor);
            this.major = major;
            return this;
        }

        public IBeaconMultiFilter build() {
            return new IBeaconMultiFilter(this);
        }
    }
}

