/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.bluetooth.BluetoothDevice;
import android.util.SparseIntArray;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.device.EddystoneDevice;
import com.kontakt.sdk.android.ble.discovery.DiscoveryUtils;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.Parser;
import com.kontakt.sdk.android.ble.discovery.ScanResponse;
import com.kontakt.sdk.android.ble.discovery.eddystone.InstanceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.NamespaceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.TLMResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.URLResolver;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.LimitedLinkedHashMap;
import java.util.Collection;
import java.util.Map;

public final class EddystoneParser
extends Parser<EddystoneDevice> {
    private static final int HEADER_LENGTH = 12;
    private static final int HEADER_BLE_FLAGS_LENGTH_OF_FLAGS_BLOCK = 2;
    private static final int HEADER_BLE_FLAGS_PDU_DATA_TYPE = 1;
    private static final int HEADER_BLE_FLAGS_DATA = 6;
    private static final int HEADER_SERVICE_UUID_LENGTH_OF_SERVICE_UUID_BLOCK = 3;
    private static final int HEADER_SERVICE_UUID_PDU_DATA_TYPE = 3;
    private static final byte HEADER_SERVICE_UUID_HIGH_ORDER_VALUE = -86;
    private static final byte HEADER_SERVICE_UUID_LOW_ORDER_VALUE = -2;
    private static final int EDDYSTONE_PACKET_TX_POWER_INDEX = 3;
    private static final NamespaceIdResolver NAMESPACE_ID_RESOLVER = new NamespaceIdResolver();
    private static final InstanceIdResolver INSTANCE_ID_RESOLVER = new InstanceIdResolver();
    private static final URLResolver URL_RESOLVER = new URLResolver();
    private static final TLMResolver TLM_RESOLVER = new TLMResolver();
    private static byte[] EDDYSTONE_SPECIFIC_HEADER = new byte[]{2, 1, 6, 3, 3, -86, -2};
    private final Map<String, ScanResponse> scanResponseCache = new LimitedLinkedHashMap<String, ScanResponse>(30);
    private final SparseIntArray txPowerCache = new SparseIntArray();
    private final Collection<EddystoneFilter> filters;
    private final Collection<EddystoneFrameType> triggerFrameTypes;

    public EddystoneParser(ScanContext scanContext) {
        super(scanContext);
        this.filters = scanContext.getEddystoneFilters();
        this.triggerFrameTypes = scanContext.getEddystoneFrameTypes();
    }

    public boolean isValidEddystoneFrame(byte[] scanRecord) {
        return scanRecord != null && scanRecord.length >= 12 && ConversionUtils.doesArrayBeginWith(scanRecord, EDDYSTONE_SPECIFIC_HEADER) && scanRecord[9] == -86 && scanRecord[10] == -2;
    }

    public void parseFrame(EddystoneFrameType frameType, String deviceAddress, byte[] scanRecord) {
        this.frameData.clear();
        this.extractFrameData(scanRecord, this.frameData);
        byte[] packetFrame = (byte[])this.frameData.get((Object)FrameDataType.EDDYSTONE_PACKET_SERVICE_DATA);
        this.saveScanResponse(deviceAddress);
        switch (frameType) {
            case UID: {
                this.saveUID(deviceAddress, packetFrame);
                break;
            }
            case URL: {
                this.saveURL(deviceAddress, packetFrame);
                break;
            }
            case TLM: {
                this.saveTLM(deviceAddress, packetFrame);
                break;
            }
            default: {
                Logger.e("Unknown Eddystone packetFrame type parsed for device with address: " + deviceAddress);
            }
        }
    }

    void saveScanResponse(String deviceAddress) {
        boolean isScanResponsePresent = this.isScanResponsePresent();
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        if (!this.scanResponseCache.containsKey(deviceAddress)) {
            ScanResponse scanResponse = isScanResponsePresent ? ScanResponse.fromScanResponseBytes(serviceData) : ScanResponse.UNKNOWN;
            this.scanResponseCache.put(deviceAddress, scanResponse);
        } else if (this.scanResponseCache.get(deviceAddress).isUnknown() && isScanResponsePresent) {
            this.scanResponseCache.put(deviceAddress, ScanResponse.fromScanResponseBytes(serviceData));
        }
    }

    void saveUID(String deviceAddress, byte[] frame) {
        this.updateTxPower(deviceAddress, frame[3]);
        String namespace = NAMESPACE_ID_RESOLVER.parse(frame);
        String instanceId = INSTANCE_ID_RESOLVER.parse(frame);
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().setNamespace(namespace).setInstanceId(instanceId).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setNamespace(namespace);
            device.setInstanceId(instanceId);
        }
    }

    void saveURL(String deviceAddress, byte[] frame) {
        this.updateTxPower(deviceAddress, frame[3]);
        String url = URL_RESOLVER.parse(frame);
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().setUrl(url).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setUrl(url);
        }
    }

    void saveTLM(String deviceAddress, byte[] frame) {
        Telemetry telemetry = TLM_RESOLVER.parse(frame);
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().setTelemetry(telemetry).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setTelemetry(telemetry);
        }
    }

    IEddystoneDevice getEddystoneDevice(BluetoothDevice bluetoothDevice, int rssi) {
        String deviceAddress = bluetoothDevice.getAddress();
        int txPower = this.getTxPower(deviceAddress.hashCode());
        int calculatedRssi = this.rssiCalculator.calculateRssi(deviceAddress.hashCode(), rssi);
        double distance = DiscoveryUtils.calculateDistance(txPower, calculatedRssi, DeviceProfile.EDDYSTONE);
        Proximity proximity = Proximity.fromDistance(distance);
        String name = bluetoothDevice.getName();
        ScanResponse scanResponse = this.getScanResponse(deviceAddress);
        EddystoneDevice cachedEddystoneDevice = this.getCachedEddystoneDevice(deviceAddress);
        EddystoneDevice device = new EddystoneDevice.Builder(cachedEddystoneDevice).setAddress(deviceAddress).setName(name).setUniqueId(scanResponse.getUniqueId()).setFirmwareVersion(scanResponse.getFirmwareVersion()).setBatteryPower(scanResponse.getBatteryPower()).setShuffled(scanResponse.isShuffled()).setTxPower(txPower).setDistance(distance).setProximity(proximity).setRssi(calculatedRssi).setTimestamp(System.currentTimeMillis()).build();
        this.putEddystoneDeviceInCache(deviceAddress, device);
        return device;
    }

    boolean filter(String deviceAddress) {
        if (this.filters.isEmpty()) {
            return true;
        }
        EddystoneDevice eddystoneDevice = this.getCachedEddystoneDevice(deviceAddress);
        if (eddystoneDevice == null) {
            return false;
        }
        for (EddystoneFilter eddystoneFilter : this.filters) {
            if (!eddystoneFilter.apply(eddystoneDevice)) continue;
            return true;
        }
        return false;
    }

    public String getNamespaceForDevice(String deviceAddress) {
        return this.getCachedEddystoneDevice(deviceAddress).getNamespace();
    }

    public boolean areTriggerFramesParsed(String deviceAddress) {
        boolean isTLMNotCached;
        boolean isURLNotCached;
        boolean isUIDNotCached;
        if (this.triggerFrameTypes.isEmpty()) {
            return true;
        }
        EddystoneDevice eddystone = this.getCachedEddystoneDevice(deviceAddress);
        boolean bl = isUIDNotCached = !this.hasFrame(eddystone, EddystoneFrameType.UID);
        if (this.triggerFrameTypes.contains((Object)EddystoneFrameType.UID) && isUIDNotCached) {
            return false;
        }
        boolean bl2 = isURLNotCached = !this.hasFrame(eddystone, EddystoneFrameType.URL);
        if (this.triggerFrameTypes.contains((Object)EddystoneFrameType.URL) && isURLNotCached) {
            return false;
        }
        boolean bl3 = isTLMNotCached = !this.hasFrame(eddystone, EddystoneFrameType.TLM);
        return !this.triggerFrameTypes.contains((Object)EddystoneFrameType.TLM) || !isTLMNotCached;
    }

    ScanResponse getScanResponse(String deviceAddress) {
        return this.scanResponseCache.get(deviceAddress);
    }

    int getTxPowerCacheSize() {
        return this.txPowerCache.size();
    }

    int getTxPower(int deviceAddressHashCode) {
        return this.txPowerCache.get(deviceAddressHashCode);
    }

    void putEddystoneDeviceInCache(String deviceAddress, EddystoneDevice device) {
        int hashCode = this.hashCodeBuilder.append(deviceAddress).build();
        this.devicesCache.put(hashCode, device);
    }

    EddystoneDevice getCachedEddystoneDevice(String deviceAddress) {
        int hashCode = this.hashCodeBuilder.append(deviceAddress).build();
        return (EddystoneDevice)this.devicesCache.get(hashCode);
    }

    private void updateTxPower(String deviceAddress, int txPower) {
        this.txPowerCache.put(deviceAddress.hashCode(), txPower);
    }

    boolean hasFrame(IEddystoneDevice eddystone, EddystoneFrameType frameType) {
        if (eddystone == null || frameType == null) {
            return false;
        }
        switch (frameType) {
            case UID: {
                return eddystone.getNamespace() != null && eddystone.getInstanceId() != null;
            }
            case URL: {
                return eddystone.getUrl() != null;
            }
            case TLM: {
                return eddystone.getTelemetry() != null;
            }
        }
        return false;
    }

    public boolean isScanResponsePresent() {
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        return serviceData != null && ScanResponse.isValidKontaktScanResponse(serviceData);
    }

    @Override
    protected void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
            this.filters.clear();
            this.devicesCache.clear();
            this.rssiCalculator.clear();
            this.scanResponseCache.clear();
            this.txPowerCache.clear();
        }
    }
}

