/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneParser;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import java.util.List;

public class EddystoneDiscoverer
extends AbstractBluetoothDeviceDiscoverer<IEddystoneNamespace, IEddystoneDevice> {
    private final EddystoneParser parser;

    public EddystoneDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract) {
        super(discoveryContract, scanContext.getActivityCheckConfiguration(), scanContext.getEddystoneNamespaces(), scanContext.getDevicesUpdateCallbackInterval(), scanContext.isNonConnectableModeSupported());
        this.parser = new EddystoneParser(scanContext);
    }

    @Override
    protected BluetoothDeviceEvent createEvent(EventType eventType, IEddystoneNamespace eddystoneNamespace, List<IEddystoneDevice> deviceList) {
        return new EddystoneDeviceEvent(eventType, eddystoneNamespace, deviceList);
    }

    @Override
    protected void onBeforeDeviceLost(IEddystoneDevice device) {
        this.parser.clearRssiCalculation(device.getAddress().hashCode());
    }

    @Override
    public boolean performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanRecord) {
        String deviceAddress = bluetoothDevice.getAddress();
        if (this.parser.isEnabled() && !this.parser.isValidEddystoneFrame(scanRecord)) {
            return PROFILE_UNRECOGNIZED;
        }
        EddystoneFrameType frameType = EddystoneFrameType.fromScanRecord(scanRecord);
        if (frameType == null) {
            return PROFILE_UNRECOGNIZED;
        }
        this.parser.parseFrame(frameType, deviceAddress, scanRecord);
        this.notifyDevicePresent(deviceAddress.hashCode(), System.currentTimeMillis());
        if (!this.isNonConnectableModeSupported && !this.parser.isScanResponsePresent()) {
            return PROFILE_UNRECOGNIZED;
        }
        if (!this.parser.areTriggerFramesParsed(deviceAddress)) {
            return PROFILE_RECOGNIZED_FILTERING_NOT_PASSED;
        }
        IEddystoneDevice device = this.parser.getEddystoneDevice(bluetoothDevice, rssi);
        if (!this.parser.filter(deviceAddress)) {
            return PROFILE_RECOGNIZED_FILTERING_NOT_PASSED;
        }
        IEddystoneNamespace namespace = this.extractNamespace(this.parser.getNamespaceForDevice(deviceAddress));
        if (namespace == null && this.getSpaceSet().contains(EddystoneNamespace.EVERYWHERE)) {
            namespace = EddystoneNamespace.EVERYWHERE;
        } else if (namespace == null) {
            return PROFILE_RECOGNIZED_NO_BELONGING_SPACE_FOUND;
        }
        this.notifySpacePresent(namespace.hashCode(), System.currentTimeMillis());
        ReplacingArrayList<Object> deviceList = this.getDevicesInSpace(namespace);
        if (deviceList == null) {
            deviceList = new ReplacingArrayList();
            this.insertDevicesIntoSpace(namespace, deviceList);
            this.onSpaceEnteredEvent(namespace);
        }
        if (deviceList.addOrReplace(device)) {
            this.onDeviceDiscoveredEvent(namespace, device);
        } else {
            this.onDevicesUpdatedEvent(namespace, deviceList);
        }
        return true;
    }

    @Override
    public void disable() {
        this.parser.disable();
    }

    IEddystoneNamespace extractNamespace(String inputNamespace) {
        for (IEddystoneNamespace namespace : this.getSpaceSet()) {
            if (!namespace.getNamespace().equals(inputNamespace)) continue;
            return namespace;
        }
        return null;
    }
}

