/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.ScanResponse;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconParser;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.LimitedLinkedHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class Parser<Device extends RemoteBluetoothDevice> {
    protected static final int CACHE_SIZE = 30;
    private static final byte[] ACCELEROMETER_MANUFACTURER_DATA_PREFIX = new byte[]{-3};
    protected final Map<Integer, Device> devicesCache = new LimitedLinkedHashMap<Integer, Device>(30);
    protected final Map<FrameDataType, byte[]> frameData = new HashMap<FrameDataType, byte[]>();
    protected final HashCodeBuilder hashCodeBuilder = HashCodeBuilder.init();
    protected boolean isEnabled = true;
    protected final RssiCalculator rssiCalculator;

    protected Parser(ScanContext scanContext) {
        this.rssiCalculator = scanContext.getRssiCalculator();
    }

    protected abstract void disable();

    public Map<FrameDataType, byte[]> getFrameData() {
        return this.frameData;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void clearRssiCalculation(int key) {
        if (this.rssiCalculator != null) {
            this.rssiCalculator.clear(key);
        }
    }

    protected void extractFrameData(byte[] scanRecord, Map<FrameDataType, byte[]> frameData) {
        int type;
        byte length;
        int index = 0;
        while (index < scanRecord.length && (length = scanRecord[index++]) != 0 && (type = ConversionUtils.asInt(scanRecord[index])) != 0) {
            byte[] data = Arrays.copyOfRange(scanRecord, index + 1, index + length);
            FrameDataType frameDataType = FrameDataType.fromByte(type);
            if (frameDataType.isServiceData()) {
                this.extractServiceData(frameData, data);
            } else if (frameDataType.isManufacturerSpecificData()) {
                this.extractManufacturerSpecificData(frameData, data);
            } else if (frameDataType != FrameDataType.UNKNOWN) {
                frameData.put(frameDataType, data);
            }
            index += length;
        }
    }

    private void extractServiceData(Map<FrameDataType, byte[]> frameData, byte[] data) {
        if (ConversionUtils.doesArrayBeginWith(data, ScanResponse.SCAN_RESPONSE_D00D_PREFIX) || ConversionUtils.doesArrayBeginWith(data, ScanResponse.SCAN_RESPONSE_PDI_PREFIX)) {
            frameData.put(FrameDataType.SCAN_RESPONSE_SERVICE_DATA, data);
        } else {
            frameData.put(FrameDataType.EDDYSTONE_PACKET_SERVICE_DATA, data);
        }
    }

    private void extractManufacturerSpecificData(Map<FrameDataType, byte[]> frameData, byte[] data) {
        if (ConversionUtils.doesArrayBeginWith(data, IBeaconParser.MANUFACTURER_DATA_IBEACON_PREFIX)) {
            frameData.put(FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA, data);
        } else if (ConversionUtils.doesArrayBeginWith(data, ACCELEROMETER_MANUFACTURER_DATA_PREFIX)) {
            frameData.put(FrameDataType.ACCELEROMETER_BEACON_MANUFACTURER_SPECIFIC_DATA, data);
        }
    }
}

