/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

public enum FrameDataType {
    IBEACON_FLAGS(1),
    IBEACON_MANUFACTURER_SPECIFIC_DATA(255),
    EDDYSTONE_PACKET_SERVICE_DATA(22),
    EDDYSTONE_FLAGS(1),
    EDDYSTONE_UUID_LIST(3),
    SCAN_RESPONSE_SERVICE_DATA(22),
    TX_POWER_LEVEL(10),
    LOCAL_NAME(9),
    ACCELEROMETER_BEACON_MANUFACTURER_SPECIFIC_DATA(255),
    UNKNOWN(0);

    private final int identifier;

    private FrameDataType(int identifier) {
        this.identifier = identifier;
    }

    public static FrameDataType fromByte(int input) {
        for (FrameDataType frameDataType : FrameDataType.values()) {
            if (input != frameDataType.getIdentifier()) continue;
            return frameDataType;
        }
        return UNKNOWN;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public boolean isServiceData() {
        return this == EDDYSTONE_PACKET_SERVICE_DATA || this == SCAN_RESPONSE_SERVICE_DATA;
    }

    public boolean isManufacturerSpecificData() {
        return this == IBEACON_MANUFACTURER_SPECIFIC_DATA || this == ACCELEROMETER_BEACON_MANUFACTURER_SPECIFIC_DATA;
    }
}

