/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;

public class EddystoneDevice
implements IEddystoneDevice {
    public static final Parcelable.Creator<EddystoneDevice> CREATOR = new Parcelable.Creator<EddystoneDevice>(){

        public EddystoneDevice createFromParcel(Parcel source) {
            return new EddystoneDevice(source);
        }

        public EddystoneDevice[] newArray(int size) {
            return new EddystoneDevice[size];
        }
    };
    private final HashCodeBuilder hashCodeBuilder;
    private String address;
    private String namespace;
    private String instanceId;
    private String url;
    private Telemetry telemetry;
    private String uniqueId;
    private String name;
    private String firmwareVersion;
    private int txPower;
    private int batteryPower;
    private boolean shuffled;
    private Proximity proximity;
    private long timestamp;
    private double distance;
    private int rssi;
    private byte[] password;

    private EddystoneDevice(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.name = bundle.getString("name");
        this.timestamp = bundle.getLong("timestamp");
        this.namespace = bundle.getString("namespaceId");
        this.instanceId = bundle.getString("instanceId");
        this.txPower = bundle.getInt("txPower");
        this.url = bundle.getString("url");
        this.distance = bundle.getDouble("accuracy");
        this.address = bundle.getString("address");
        this.proximity = (Proximity)((Object)bundle.getSerializable("proximity"));
        this.rssi = bundle.getInt("rssi");
        this.telemetry = (Telemetry)bundle.getParcelable("telemetry");
        this.password = bundle.getByteArray("password");
        this.firmwareVersion = bundle.getString("firmware");
        this.uniqueId = bundle.getString("uniqueId");
        this.batteryPower = bundle.getInt("battery");
        this.shuffled = bundle.getBoolean("shuffled");
        this.hashCodeBuilder = HashCodeBuilder.init();
    }

    private EddystoneDevice(Builder builder) {
        this.name = builder.name;
        this.timestamp = builder.timestamp;
        this.namespace = builder.namespace;
        this.instanceId = builder.instanceId;
        this.txPower = builder.txPower;
        this.url = builder.url;
        this.distance = builder.distance;
        this.address = builder.address;
        this.proximity = builder.proximity;
        this.rssi = builder.rssi;
        this.telemetry = builder.telemetry;
        this.firmwareVersion = builder.firmwareVersion;
        this.uniqueId = builder.uniqueId;
        this.batteryPower = builder.batteryPower;
        this.shuffled = builder.shuffled;
        this.password = builder.password;
        this.hashCodeBuilder = HashCodeBuilder.init();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return this.hashCodeBuilder.append(this.address).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EddystoneDevice)) {
            return false;
        }
        EddystoneDevice device = (EddystoneDevice)o;
        return TextUtils.equals((CharSequence)this.address, (CharSequence)device.address);
    }

    public String toString() {
        return "EddystoneDevice{address='" + this.address + '\'' + ", uniqueId='" + this.uniqueId + '\'' + ", namespace='" + this.namespace + '\'' + ", instanceId='" + this.instanceId + '\'' + ", url='" + this.url + '\'' + ", rssi=" + this.rssi + '}';
    }

    @Override
    public int compareTo(IEddystoneDevice another) {
        if (this == another) {
            return 0;
        }
        int namespaceComparisonResult = this.namespace.compareTo(another.getNamespace());
        if (namespaceComparisonResult == 0) {
            int instanceComparisonResult = this.instanceId.compareTo(another.getInstanceId());
            if (instanceComparisonResult == 0) {
                return this.url.compareTo(another.getUrl());
            }
            return instanceComparisonResult;
        }
        return namespaceComparisonResult;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("namespaceId", this.namespace);
        bundle.putString("instanceId", this.instanceId);
        bundle.putString("url", this.url);
        bundle.putInt("txPower", this.txPower);
        bundle.putLong("timestamp", this.timestamp);
        bundle.putDouble("accuracy", this.distance);
        bundle.putSerializable("proximity", (Serializable)((Object)this.proximity));
        bundle.putInt("rssi", this.rssi);
        bundle.putString("address", this.address);
        bundle.putParcelable("telemetry", (Parcelable)this.telemetry);
        bundle.putByteArray("password", this.password);
        bundle.putString("name", this.name);
        bundle.putString("firmware", this.firmwareVersion);
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putInt("battery", this.batteryPower);
        bundle.putBoolean("shuffled", this.shuffled);
        dest.writeBundle(bundle);
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Proximity getProximity() {
        return this.proximity;
    }

    @Override
    public int getRssi() {
        return this.rssi;
    }

    @Override
    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(byte[] password) {
        SDKPreconditions.checkNotNull(password, "Password is null");
        int passwordLength = password.length;
        this.password = new byte[passwordLength];
        System.arraycopy(password, 0, this.password, 0, passwordLength);
    }

    @Override
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public int getBatteryPower() {
        return this.batteryPower;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public DeviceProfile getProfile() {
        return DeviceProfile.EDDYSTONE;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Telemetry getTelemetry() {
        return this.telemetry;
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry = telemetry;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    public static class Builder {
        private String namespace;
        private String instanceId;
        private int txPower;
        private String url;
        private double distance;
        private String address;
        private Proximity proximity;
        private int rssi;
        private long timestamp;
        private String firmwareVersion;
        private String uniqueId;
        private int batteryPower;
        private String name;
        private boolean shuffled;
        private Telemetry telemetry;
        private byte[] password;

        public Builder() {
        }

        public Builder(IEddystoneDevice eddystoneDevice) {
            this.name = eddystoneDevice.getName();
            this.timestamp = eddystoneDevice.getTimestamp();
            this.namespace = eddystoneDevice.getNamespace();
            this.instanceId = eddystoneDevice.getInstanceId();
            this.txPower = eddystoneDevice.getTxPower();
            this.url = eddystoneDevice.getUrl();
            this.distance = eddystoneDevice.getDistance();
            this.address = eddystoneDevice.getAddress();
            this.proximity = eddystoneDevice.getProximity();
            this.rssi = eddystoneDevice.getRssi();
            if (eddystoneDevice.getTelemetry() != null) {
                this.telemetry = new Telemetry.Builder().setBatteryVoltage(eddystoneDevice.getTelemetry().getBatteryVoltage()).setTemperature(eddystoneDevice.getTelemetry().getTemperature()).setPduCount(eddystoneDevice.getTelemetry().getPduCount()).setTimeSincePowerUp(eddystoneDevice.getTelemetry().getTimeSincePowerUp()).setVersion(eddystoneDevice.getTelemetry().getVersion()).build();
            }
            this.firmwareVersion = eddystoneDevice.getFirmwareVersion();
            this.uniqueId = eddystoneDevice.getUniqueId();
            this.batteryPower = eddystoneDevice.getBatteryPower();
            this.shuffled = eddystoneDevice.isShuffled();
        }

        public Builder setResolvedId(ResolvedId resolvedId) {
            EddystoneUid eddystoneUID = resolvedId.getEddystoneUID();
            this.namespace = eddystoneUID.getNamespace();
            this.instanceId = eddystoneUID.getInstanceId();
            this.uniqueId = resolvedId.getUniqueId();
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setTelemetry(Telemetry telemetry) {
            this.telemetry = telemetry;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder setDistance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setProximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder setRssi(int rssi) {
            this.rssi = rssi;
            return this;
        }

        public Builder setFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public Builder setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder setBatteryPower(int batteryPower) {
            this.batteryPower = batteryPower;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setShuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setPassword(byte[] password) {
            SDKPreconditions.checkNotNull(password, "Password is null");
            int passwordLength = password.length;
            this.password = new byte[passwordLength];
            System.arraycopy(password, 0, this.password, 0, passwordLength);
            return this;
        }

        public EddystoneDevice build() {
            return new EddystoneDevice(this);
        }
    }
}

