/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.regex.Pattern;

public final class InternalProximityManagerConfiguration {
    private static final int MIN_RESOLVE_INTERVAL = 0;
    private static final int MIN_MONITORING_SYNC_INTERVAL = 0;
    private static final String FILE_NAME_REGEX = "^[^(^?|*<\":>+\\[\\]\\/'{})]+$";
    private static final Pattern FILE_NAME_MATCHER = Pattern.compile("^[^(^?|*<\":>+\\[\\]\\/'{})]+$");
    public static final String DEFAULT_CACHE_FILE_NAME = "resolved.che";
    public static final int DEFAULT_RESOLVE_INTERVAL = 3;
    public static final int DEFAULT_MONITORING_SYNC_INTERVAL = 10;
    public static final boolean DEFAULT_MONITORING_ENABLED = true;
    public static final InternalProximityManagerConfiguration DEFAULT = new Builder().setCacheFileName("resolved.che").setResolveInterval(3).setMonitoringSyncInterval(10).setMonitoringEnabled(true).build();
    private final String cacheFileName;
    private final int resolveInterval;
    private final int monitoringSyncInterval;
    private final boolean monitoringEnabled;

    private InternalProximityManagerConfiguration(Builder builder) {
        this.cacheFileName = builder.cacheFileName;
        this.resolveInterval = builder.resolveInterval;
        this.monitoringSyncInterval = builder.monitoringSyncInterval;
        this.monitoringEnabled = builder.monitoringEnabled;
    }

    public String getCacheFileName() {
        return this.cacheFileName;
    }

    public int getResolveInterval() {
        return this.resolveInterval;
    }

    public int getMonitoringSyncInterval() {
        return this.monitoringSyncInterval;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public static class Builder {
        private String cacheFileName = "resolved.che";
        private int resolveInterval = 3;
        private boolean monitoringEnabled = true;
        private int monitoringSyncInterval = 10;

        public Builder setCacheFileName(String cacheFileName) {
            SDKPreconditions.checkNotNull(cacheFileName, "Cache file name cannot be null!");
            boolean match = FILE_NAME_MATCHER.matcher(cacheFileName).matches();
            SDKPreconditions.checkArgument(match, "Incorrect cache file name");
            this.cacheFileName = cacheFileName;
            return this;
        }

        public Builder setResolveInterval(int resolveIntervalSeconds) {
            SDKPreconditions.checkArgument(resolveIntervalSeconds > 0, "Resolve interval must be greater than 0!");
            this.resolveInterval = resolveIntervalSeconds;
            return this;
        }

        public Builder setMonitoringSyncInterval(int monitoringSyncIntervalSeconds) {
            SDKPreconditions.checkArgument(monitoringSyncIntervalSeconds > 0, "Monitoring sync interval must be greater than 0!");
            this.monitoringSyncInterval = monitoringSyncIntervalSeconds;
            return this;
        }

        public Builder setMonitoringEnabled(boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
            return this;
        }

        public InternalProximityManagerConfiguration build() {
            return new InternalProximityManagerConfiguration(this);
        }
    }
}

