/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.EddystoneApiResolveStrategy;
import com.kontakt.sdk.android.ble.cache.EddystoneCacheResolveStrategy;
import com.kontakt.sdk.android.ble.cache.EddystoneResolveRequest;
import com.kontakt.sdk.android.ble.cache.EddystoneResolveStrategy;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.device.EddystoneDevice;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.EddystoneFutureUID;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

class EddystoneUIDResolver
implements Runnable {
    private static final String TAG = "EddystoneUIDResolver";
    private static final int REQUEST_UNIT_SIZE = 120;
    private static final int DEFAULT_BUFFER_SIZE = 200;
    private static final DeviceProfile DEVICE_PROFILE = DeviceProfile.EDDYSTONE;
    private final ArrayBlockingQueue<EddystoneResolveRequest> requestQueue;
    private final FutureShufflesCache cache;
    private final Collection<EddystoneResolveStrategy> strategies;

    EddystoneUIDResolver(FutureShufflesCache futureShufflesCache, IKontaktCloud kontaktCloud) {
        this.cache = futureShufflesCache;
        this.requestQueue = new ArrayBlockingQueue(200, true);
        LinkedList<EddystoneResolveStrategy> resolvers = new LinkedList<EddystoneResolveStrategy>();
        EddystoneCacheResolveStrategy cacheStrategy = new EddystoneCacheResolveStrategy(this.cache);
        EddystoneApiResolveStrategy apiStrategy = new EddystoneApiResolveStrategy(kontaktCloud);
        resolvers.add(cacheStrategy);
        resolvers.add(apiStrategy);
        this.strategies = Collections.unmodifiableCollection(resolvers);
    }

    @Override
    public void run() {
        if (!this.cache.isInitialized()) {
            Logger.d("EddystoneUIDResolver Cache not initialized yet");
            return;
        }
        ArrayList<EddystoneResolveRequest> requests = new ArrayList<EddystoneResolveRequest>();
        this.requestQueue.drainTo(requests, 120);
        if (requests.isEmpty()) {
            Logger.d("EddystoneUIDResolver Nothing to resolve");
            return;
        }
        try {
            Logger.d("EddystoneUIDResolver Start resolving");
            Map<EddystoneUid, EddystoneResolveRequest> requestsRegister = this.buildRequestsRegister(requests);
            List<EddystoneFutureUID> shuffles = this.resolveShuffles(requestsRegister);
            Map<EddystoneUid, EddystoneFutureUID> shufflesRegister = this.buildShufflesRegister(shuffles);
            this.evictOutdatedCacheEntries(requestsRegister, shufflesRegister);
            this.handleRequests(requestsRegister, shufflesRegister);
            this.cache.serialize();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (UnknownHostException.class.isInstance(cause) || SocketTimeoutException.class.isInstance(cause)) {
                this.requestQueue.addAll(requests);
            }
            Logger.e("EddystoneUIDResolver Error occurs when try to resolve shuffled device ", e);
        }
    }

    void addResolveRequest(EddystoneResolveRequest request) {
        if (this.requestQueue.contains(request)) {
            return;
        }
        try {
            this.requestQueue.add(request);
        }
        catch (IllegalStateException fullQueueException) {
            Logger.e("Could not add Eddystone to resolve", fullQueueException);
        }
    }

    public void markIgnored(RemoteBluetoothDevice beacon) {
        for (EddystoneResolveRequest request : this.requestQueue) {
            if (!request.getFakeDevice().equals(beacon)) continue;
            request.setStatus(ResolveRequestStatus.IGNORED);
        }
    }

    public void clear() {
        this.requestQueue.clear();
    }

    private Map<EddystoneUid, EddystoneResolveRequest> buildRequestsRegister(List<EddystoneResolveRequest> requests) {
        HashMap<EddystoneUid, EddystoneResolveRequest> requestsRegister = new HashMap<EddystoneUid, EddystoneResolveRequest>();
        for (EddystoneResolveRequest request : requests) {
            EddystoneUid eddystoneUID = EddystoneUid.fromDevice(request.getFakeDevice());
            requestsRegister.put(eddystoneUID, request);
        }
        return requestsRegister;
    }

    private List<EddystoneFutureUID> resolveShuffles(Map<EddystoneUid, EddystoneResolveRequest> requestsRegister) throws Exception {
        ArrayList<EddystoneFutureUID> shuffles = new ArrayList<EddystoneFutureUID>();
        for (EddystoneResolveStrategy strategy : this.strategies) {
            List<EddystoneFutureUID> resolved = strategy.resolve(requestsRegister);
            shuffles.addAll(resolved);
        }
        return shuffles;
    }

    private Map<EddystoneUid, EddystoneFutureUID> buildShufflesRegister(List<EddystoneFutureUID> shuffles) {
        HashMap<EddystoneUid, EddystoneFutureUID> shufflesRegister = new HashMap<EddystoneUid, EddystoneFutureUID>();
        for (EddystoneFutureUID futureShuffle : shuffles) {
            shufflesRegister.put(futureShuffle.getQueriedBy(), futureShuffle);
        }
        return shufflesRegister;
    }

    private void evictOutdatedCacheEntries(Map<EddystoneUid, EddystoneResolveRequest> requestsRegister, Map<EddystoneUid, EddystoneFutureUID> shufflesRegister) {
        ArrayList<String> uniqueIds = new ArrayList<String>();
        for (Map.Entry<EddystoneUid, EddystoneResolveRequest> entry : requestsRegister.entrySet()) {
            EddystoneUid queriedBy = entry.getKey();
            EddystoneResolveRequest request = entry.getValue();
            EddystoneFutureUID eddystoneFutureUID = shufflesRegister.get(queriedBy);
            if (eddystoneFutureUID == null || ResolverType.CACHE == request.getResolvedBy()) continue;
            uniqueIds.add(eddystoneFutureUID.getUniqueId());
        }
        this.cache.evict(uniqueIds, DEVICE_PROFILE);
    }

    private void handleRequests(Map<EddystoneUid, EddystoneResolveRequest> requestsRegister, Map<EddystoneUid, EddystoneFutureUID> shufflesRegister) {
        for (Map.Entry<EddystoneUid, EddystoneResolveRequest> entry : requestsRegister.entrySet()) {
            this.handleRequest(shufflesRegister, entry);
        }
    }

    private void handleRequest(Map<EddystoneUid, EddystoneFutureUID> shufflesRegister, Map.Entry<EddystoneUid, EddystoneResolveRequest> entry) {
        EddystoneUid queriedBy = entry.getKey();
        EddystoneFutureUID eddystoneFutureUID = shufflesRegister.get(queriedBy);
        if (eddystoneFutureUID == null) {
            this.cache.populate(queriedBy.toString(), FutureShufflesCache.PHANTOM_ENTRY);
            return;
        }
        EddystoneUid resolvedId = eddystoneFutureUID.getResolved();
        EddystoneResolveRequest request = entry.getValue();
        String uniqueId = eddystoneFutureUID.getUniqueId();
        ResolvedId resolvedEddystoneUID = ResolvedId.create(resolvedId.toString(), uniqueId, DEVICE_PROFILE);
        if (ResolverType.CACHE != request.getResolvedBy()) {
            this.addNewCacheEntries(eddystoneFutureUID, resolvedEddystoneUID);
        }
        if (ResolveRequestStatus.RESOLVED == request.getStatus()) {
            this.notifyListeners(request, resolvedEddystoneUID);
        }
    }

    private void addNewCacheEntries(EddystoneFutureUID eddystoneFutureUID, ResolvedId resolvedEddystoneUID) {
        for (EddystoneUid futureShuffle : eddystoneFutureUID.getFutureIds()) {
            this.cache.populate(futureShuffle.toString(), resolvedEddystoneUID);
        }
        this.cache.populate(resolvedEddystoneUID.getEddystoneUID().toString(), resolvedEddystoneUID);
    }

    private void notifyListeners(EddystoneResolveRequest request, ResolvedId resolvedEddystoneUID) {
        IEddystoneDevice fakeDevice = request.getFakeDevice();
        EddystoneDevice resolvedDevice = new EddystoneDevice.Builder(fakeDevice).setResolvedId(resolvedEddystoneUID).build();
        Integer proximityManagerId = request.getSourceProximityManagerId();
        EddystoneDeviceEvent deviceEvent = EddystoneDeviceEvent.createNewDiscovered(resolvedDevice, request.getNamespace(), request.getTimestamp());
        this.cache.notifyListeners(proximityManagerId, deviceEvent);
    }
}

