package com.kontakt.sdk.android.common.profile;

/**
 * Currently supported remote bluetooth device profiles by kontakt.io Android SDK.
 */
public enum DeviceProfile {
  IBEACON(0x01),
  EDDYSTONE(0x02);

  final int activeProfileValue;

  DeviceProfile(final int activeProfileValue) {
    this.activeProfileValue = activeProfileValue;
  }

  public int getActiveProfileValue() {
    return activeProfileValue;
  }

  public static DeviceProfile getActiveProfile(final int activeProfile) {
    for (DeviceProfile deviceProfile : values()) {
      if (deviceProfile.activeProfileValue == activeProfile) {
        return deviceProfile;
      }
    }

    return null;
  }
}
