package com.kontakt.sdk.android.common.model;

/**
 * Enumeration type of device model.
 */
public enum Model {

  /**
   * Smart beacon device model.
   */
  SMART_BEACON,

  /**
   * USB beacon device model.
   */
  USB_BEACON,

  /**
   * Sensor beacon device model.
   */
  SENSOR_BEACON,

  /**
   * Cloud beacon device model.
   */
  CLOUD_BEACON,

  /**
   * External device model.
   */
  EXTERNAL;

  public static Model fromString(String modelString) {
    if (modelString != null) {
      for (Model model : Model.values()) {
        if (modelString.equalsIgnoreCase(model.name())) {
          return model;
        }
      }
    }
    return SMART_BEACON;
  }
}
