package com.kontakt.sdk.android.cloud.util;

import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;

/**
 * String utility methods.
 */
public final class StringUtils {

  private StringUtils() {
    // prevent from creation
  }

  /**
   * Joins the elements of the provided list into a single String containing the provided elements.
   * @param elements the list of values to join together.
   * @param separator the separator value to use.
   * @return the joined String.
   */
  public static String join(List<?> elements, String separator) {
    SDKPreconditions.checkNotNull(elements, "elements cannot be null");
    SDKPreconditions.checkNotNull(separator, "separator cannot be null");
    StringBuilder result = new StringBuilder();
    int size = elements.size();
    for (int i = 0; i < size; i++) {
      Object element = elements.get(i);
      result.append(element.toString());
      if (i < size - 1) {
        result.append(separator);
      }
    }
    return result.toString();
  }

  /**
   * Joins the elements of the provided array into a single String containing the provided elements.
   * @param elements the array of values to join together.
   * @param separator the separator value to use.
   * @return the joined String.
   */
  public static String join(Object[] elements, String separator) {
    SDKPreconditions.checkNotNull(elements, "elements cannot be null");
    SDKPreconditions.checkNotNull(separator, "separator cannot be null");
    StringBuilder result = new StringBuilder();
    int size = elements.length;
    for (int i = 0; i < size; i++) {
      Object element = elements[i];
      result.append(element.toString());
      if (i < size - 1) {
        result.append(separator);
      }
    }
    return result.toString();
  }

}
