package com.kontakt.sdk.android.cloud.response.paginated;

import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.Venue;
import java.util.List;

/**
 * Venues API response representation composed of venue list and search meta data.
 */
public class Venues extends PaginatedResponse<List<Venue>> {

  @SerializedName("venues")
  protected List<Venue> venues;

  /**
   * Returns the venue list.
   * @return the venue list.
   */
  @Override public List<Venue> getContent() {
    return venues;
  }
}
