package com.kontakt.sdk.android.cloud.response.paginated;

import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.Credentials;
import java.util.List;

/**
 * Devices API response representation composed of device credentials and search meta data.
 */
public class CredentialsList extends PaginatedResponse<List<Credentials>> {

  @SerializedName("credentials")
  private List<Credentials> credentials;

  /**
   * Returns the device credentials list.
   * @return the device credentials list.
   */
  @Override public List<Credentials> getContent() {
    return credentials;
  }

}
