package com.kontakt.sdk.android.cloud.exception;

/**
 * Signals that an error occurred while interacting with Kontakt.io Proximity REST API.
 * This exception will be thrown by Kontakt Cloud Client if the request to the API was built
 * incorrectly e.g. contains not applicable query parameter values.
 */
public class KontaktCloudException extends Exception {

  private static final String DEFAULT_MESSAGE = "Kontakt Cloud exception";

  private int errorCode;

  /**
   * Constructs an {@code KontaktCloudException} with default error detail message.
   */
  public KontaktCloudException() {
    super(DEFAULT_MESSAGE);
  }

  /**
   * Constructs an {@code KontaktCloudException} with the specified cause.
   * @param throwable the cause
   */
  public KontaktCloudException(Throwable throwable) {
    super(throwable);
  }

  /**
   * Constructs an {@code KontaktCloudException} with the specified detail message.
   * @param detailMessage the detail message.
   */
  public KontaktCloudException(String detailMessage) {
    super(detailMessage);
  }

  /**
   * Constructs an {@code KontaktCloudException} with the specified detail message and error code.
   * @param message the detail message.
   * @param errorCode the error code.
   */
  public KontaktCloudException(String message, int errorCode) {
    super(message);
    this.errorCode = errorCode;
  }

  public int getErrorCode() {
    return errorCode;
  }
}
