package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Firmwares;
import com.kontakt.sdk.android.common.model.Firmware;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

public interface FirmwaresService {

  @GET("/firmware/{name}")
  Call<Firmware> getFirmware(@Path("name") String name, @Query("deviceType") String deviceType);

  @GET("/firmware")
  Call<Firmwares> getFirmwares(@QueryMap Map<String, String> params);

  @GET("/firmware")
  Call<Firmwares> getFirmwares(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET("/firmware/{model}/{name}/file")
  Call<ResponseBody> getFirmwareFile(@Path("name") String name, @Path("model") String model, @Query("deviceType") String deviceType);

  @GET
  Call<ResponseBody> getFirmwareFileFromUrl(@Url String url);

  @POST("/firmware/schedule")
  Call<String> scheduleFirmwareUpdate(@QueryMap Map<String, String> params);

  @POST("/firmware/unschedule")
  Call<String> unscheduleFirmwareUpdate(@QueryMap Map<String, String> params);

}
