package com.kontakt.sdk.android.cloud.api.executor.venues;

import com.kontakt.sdk.android.cloud.api.VenuesApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.common.model.Venue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link VenuesApi}. Use this class if you want to get
 * single venue through fluent API in chained fashion, for instance:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   Venue venue = kontaktCloud.venues().fetch(ID).execute();
 *   </code>
 * </pre>
 */
public class VenueRequestExecutor extends RequestExecutor<Venue> {

  private final VenuesService venuesService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and venue's id.
   * @param venuesService the venues API service.
   * @param id the venue's unique identifier.
   */
  public VenueRequestExecutor(final VenuesService venuesService, final UUID id) {
    this.venuesService = venuesService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override protected Call<Venue> prepareCall() {
    return venuesService.getVenue(id.toString());
  }

  @Override protected Map<String, String> params() {
    return new HashMap<>();
  }
}
