package com.kontakt.sdk.android.cloud.api.executor.venues;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.VenuesApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link VenuesApi}. Use this class if you want to delete
 * venues through fluent API in chained fashion, for example:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   kontaktCloud.venues().delete(ID).execute();
 *   </code>
 * </pre>
 */
public class DeleteVenueRequestExecutor extends RequestExecutor<String> {

  private final VenuesService venuesService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and venue's identifier.
   * @param venuesService the venues API service.
   * @param id the venue's unique identifier.
   */
  public DeleteVenueRequestExecutor(final VenuesService venuesService, final UUID id) {
    this.venuesService = venuesService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override protected Call<String> prepareCall() {
    return venuesService.deleteVenue(params());
  }

  /**
   * {@inheritDoc}
   */
  @Override protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Venues.VENUE_ID_PARAMETER, id.toString());
    return params;
  }
}
