package com.kontakt.sdk.android.cloud.api.executor.notifications;

import android.content.Context;
import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.NotificationsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class RegisterTokenRequestExecutor extends RequestExecutor<Void> {

  private static final String PLATFORM_NAME = "ANDROID";

  private final NotificationsService notificationsService;

  private final String token;
  private Context context;
  private boolean sandbox;

  public RegisterTokenRequestExecutor(final NotificationsService notificationsService, final String token) {
    this.notificationsService = notificationsService;
    this.token = token;
  }

  public RegisterTokenRequestExecutor withContext(final Context context) {
    this.context = SDKPreconditions.checkNotNull(context, "context cannot be null");
    return this;
  }

  public RegisterTokenRequestExecutor forSandbox(final boolean sandbox) {
    this.sandbox = sandbox;
    return this;
  }

  @Override public Void execute() throws IOException, KontaktCloudException {
    checkPreconditions();
    return super.execute();
  }

  @Override public void execute(final CloudCallback<Void> callback) {
    checkPreconditions();
    super.execute(callback);
  }

  @Override protected Call<Void> prepareCall() {
    return notificationsService.registerToken(params());
  }

  private void checkPreconditions() {
    SDKPreconditions.checkState(context != null, "cannot register token - specify context");
  }

  @Override protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Notifications.TOKEN_PARAMETER, token);
    params.put(CloudConstants.Notifications.PLATFORM_PARAMETER, PLATFORM_NAME);
    params.put(CloudConstants.Notifications.BUNDLE_ID_PARAMETER, context.getApplicationContext().getPackageName());
    params.put(CloudConstants.Notifications.SANDBOX_PARAMETER, String.valueOf(sandbox));

    return params;
  }
}
