package com.kontakt.sdk.android.cloud.api.executor.actions;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.ActionsApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link ActionsApi}. Use this class if you want to delete actions.
 * Example of use:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   kontaktCloud.actions().delete(ID).execute();
 *   </code>
 * </pre>
 */
public class DeleteActionRequestExecutor extends RequestExecutor<String> {

  private final ActionsService actionsService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and action's id.
   * @param actionsService the actions API service.
   * @param id the action's unique identifier.
   */
  public DeleteActionRequestExecutor(final ActionsService actionsService, final UUID id) {
    this.actionsService = actionsService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override protected Call<String> prepareCall() {
    return actionsService.deleteAction(params());
  }

  /**
   * {@inheritDoc}
   */
  @Override protected Map<String, String> params() {
    Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Actions.ACTION_ID_PARAMETER, id.toString());
    return params;
  }

}
