package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.presets.PresetRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.presets.PresetsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PresetsService;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * An abstract representation of Presets API endpoint. Provides executors that can be
 * used to handle all preset-related requests.
 */
public class PresetsApi {

  private final PresetsService presetsService;

  /**
   * Constructs Presets API endpoint initialized with corresponding service class.
   * @param presetsService the presets API service.
   */
  public PresetsApi(final PresetsService presetsService) {
    this.presetsService = presetsService;
  }

  /**
   * Provides executor that can be used to obtain single preset by name.
   * @param name the preset's name.
   * @return the request executor.
   */
  public PresetRequestExecutor fetch(final String name) {
    SDKPreconditions.checkNotNull(name, "name cannot be null");
    return new PresetRequestExecutor(presetsService, name);
  }

  /**
   * Provides executor that can be used to obtain presets.
   * @return the request executor.
   */
  public PresetsRequestExecutor fetch() {
    return new PresetsRequestExecutor(presetsService);
  }
}
