package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.commands.CommandsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.CommandsService;

/**
 * An abstract representation of Commands API endpoint. Provides executors that can be
 * used to handle all command-related requests.
 */
public class CommandsApi {

  private final CommandsService commandsService;

  /**
   * Constructs Commands API endpoint initialized with corresponding service class.
   * @param commandsService the commands API service.
   */
  public CommandsApi(final CommandsService commandsService) {
    this.commandsService = commandsService;
  }

  /**
   * Provides executor that can be used to obtain commands.
   * @return the request executor.
   */
  public CommandsRequestExecutor fetch() {
    return new CommandsRequestExecutor(commandsService);
  }
}
