package com.kontakt.sdk.android.ble.spec;

/**
 * Eddystone-specific frame type.
 */
public enum EddystoneFrameType {

  /**
   * The UID frame type.
   */
  UID(0x00),
  /**
   * The URL frame type.
   */
  URL(0x10),
  /**
   * The TLM frame type.
   */
  TLM(0x20);

  private static final int FRAME_TYPE_MASK = 0x00F0;

  private static final int FRAME_TYPE_BYTE_POSITION = 11;

  EddystoneFrameType(int binaryRepresentation) {
    this.binaryRepresentation = binaryRepresentation;
  }

  private final int binaryRepresentation;

  /**
   * Extracts frame type from given scan record.
   *
   * @param scanRecord the scan record
   * @return the eddystone frame type
   */
  public static EddystoneFrameType fromScanRecord(final byte[] scanRecord) {
    final int frameType = scanRecord[FRAME_TYPE_BYTE_POSITION] &= FRAME_TYPE_MASK;

    for (EddystoneFrameType eddystoneFrameType : EddystoneFrameType.values()) {
      if (eddystoneFrameType.binaryRepresentation == frameType) {
        return eddystoneFrameType;
      }
    }

    return null;
  }
}

