package com.kontakt.sdk.android.ble.manager.listeners;

import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;

/**
 * Listener used to inform when space (IBeacon region or Eddystone namespace) is entered or abandoned.
 */
public interface SpaceListener {

  /**
   * Callback invoked when IBeacon region is entered.
   * @param region {@link IBeaconRegion}
   */
  void onRegionEntered(IBeaconRegion region);

  /**
   * Callback invoked when IBeacon region is abandoned.
   * @param region {@link IBeaconRegion}
   */
  void onRegionAbandoned(IBeaconRegion region);

  /**
   * Callback invoked when Eddystone namespace is entered.
   * @param namespace {@link IEddystoneNamespace}
   */
  void onNamespaceEntered(IEddystoneNamespace namespace);

  /**
   * Callback invoked when Eddystone namespace is abandoned.
   * @param namespace {@link IEddystoneNamespace}
   */
  void onNamespaceAbandoned(IEddystoneNamespace namespace);
}
