package com.kontakt.sdk.android.ble.discovery.ibeacon;

import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;

final class RegionValidator implements Validator<IBeaconDevice, IBeaconRegion> {

  @Override
  public boolean isValid(IBeaconDevice iBeaconDevice, IBeaconRegion iBeaconRegion) {
    if (iBeaconRegion == BeaconRegion.EVERYWHERE) {
      return true;
    }

    if (iBeaconDevice.getProximityUUID().equals(iBeaconRegion.getProximity())) {

      if (iBeaconRegion.getMajor() != BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() != BeaconRegion.ANY_MINOR) {
        return iBeaconDevice.getMajor() == iBeaconRegion.getMajor() && iBeaconDevice.getMinor() == iBeaconRegion.getMinor();
      }

      if (iBeaconRegion.getMajor() == BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() != BeaconRegion.ANY_MINOR) {
        return iBeaconDevice.getMinor() == iBeaconRegion.getMinor();
      }

      if (iBeaconRegion.getMajor() != BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() == BeaconRegion.ANY_MINOR) {
        return iBeaconDevice.getMajor() == iBeaconRegion.getMajor();
      }

      if (iBeaconRegion.getMajor() == BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() == BeaconRegion.ANY_MINOR) {
        return true;
      }
    }

    return false;
  }
}
