package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystoneUtils;

final class URLResolver implements EddystonePropertyResolver<String> {

  static final int SCAN_RECORD_EDDYSTONE_URL_START_INDEX = 4;

  @Override
  public String parse(byte[] frame) {
    if (frame == null) {
      return null;
    }

    final int urlLength = frame.length - SCAN_RECORD_EDDYSTONE_URL_START_INDEX;
    byte[] bytes = ConversionUtils.extractPayload(frame, SCAN_RECORD_EDDYSTONE_URL_START_INDEX, urlLength);

    return EddystoneUtils.deserializeUrl(bytes);
  }
}
