package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.common.util.ConversionUtils;

final class InstanceIdResolver implements EddystonePropertyResolver<String> {

  static final int INSTANCE_ID_START_INDEX = 14;

  private static final int INSTANCE_ID_LENGTH = 6;
  private static final int MASK = 0x00FF;
  private static final String FORMAT = "%02x";

  private final StringBuilder stringBuilder = new StringBuilder();

  @Override
  public String parse(byte[] scanRecord) {
    if (scanRecord == null) {
      return null;
    }

    byte[] bytes = ConversionUtils.extractPayload(scanRecord, INSTANCE_ID_START_INDEX, INSTANCE_ID_LENGTH);

    stringBuilder.setLength(0);

    for (byte byteValue : bytes) {
      stringBuilder.append(String.format(FORMAT, byteValue & MASK));
    }

    return stringBuilder.toString();
  }
}
