package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.Constants;
import java.util.ArrayList;
import java.util.List;

public class EddystoneDeviceEvent extends AbstractBluetoothDeviceEvent {

  public static final Parcelable.Creator<EddystoneDeviceEvent> CREATOR = new Parcelable.Creator<EddystoneDeviceEvent>() {
    @Override
    public EddystoneDeviceEvent createFromParcel(Parcel source) {
      Bundle bundle = source.readBundle(getClass().getClassLoader());

      EventType eventType = (EventType) bundle.getSerializable(PARCELABLE_EVENT_TYPE);
      IEddystoneNamespace IEddystoneNamespace = bundle.getParcelable(Constants.Eddystone.NAMESPACE);
      ArrayList<IEddystoneDevice> deviceList = bundle.getParcelableArrayList(PARCELABLE_DEVICE_LIST);
      long timestamp = bundle.getLong(PARCELABLE_TIMESTAMP);

      return new EddystoneDeviceEvent(eventType, IEddystoneNamespace, deviceList, timestamp);
    }

    @Override
    public EddystoneDeviceEvent[] newArray(int size) {
      return new EddystoneDeviceEvent[size];
    }
  };

  private final IEddystoneNamespace iEddystoneNamespace;

  public EddystoneDeviceEvent(final EventType eventType, final IEddystoneNamespace iEddystoneNamespace, final List<IEddystoneDevice> deviceList) {
    this(eventType, iEddystoneNamespace, deviceList, System.currentTimeMillis());
  }

  private EddystoneDeviceEvent(final EventType eventType, final IEddystoneNamespace iEddystoneNamespace, final List<IEddystoneDevice> deviceList,
      final long timestamp) {
    super(eventType, DeviceProfile.EDDYSTONE, deviceList, timestamp);
    this.iEddystoneNamespace = iEddystoneNamespace;
  }

  public IEddystoneNamespace getNamespace() {
    return iEddystoneNamespace;
  }

  @Override
  public List<IEddystoneDevice> getDeviceList() {
    return (List<IEddystoneDevice>) super.getDeviceList();
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    Bundle bundle = new Bundle(getClass().getClassLoader());
    bundle.putParcelable(Constants.Eddystone.NAMESPACE, iEddystoneNamespace);
    bundle.putSerializable(PARCELABLE_EVENT_TYPE, getEventType());
    bundle.putParcelableArrayList(PARCELABLE_DEVICE_LIST, (ArrayList<? extends Parcelable>) deviceList);
    bundle.putLong(PARCELABLE_TIMESTAMP, timestamp);

    dest.writeBundle(bundle);
  }

  public static EddystoneDeviceEvent createNewDiscovered(IEddystoneDevice resolvedDevice, IEddystoneNamespace namespace, long timestamp) {
    ArrayList<IEddystoneDevice> eddystoneDevices = new ArrayList<>();
    eddystoneDevices.add(resolvedDevice);
    return new EddystoneDeviceEvent(EventType.DEVICE_DISCOVERED, namespace, eddystoneDevices, timestamp);
  }

  public static EddystoneDeviceEvent of(EddystoneDeviceEvent eddystoneDeviceEvent, List<IEddystoneDevice> eddystoneDevices) {
    return new EddystoneDeviceEvent(eddystoneDeviceEvent.getEventType(), eddystoneDeviceEvent.getNamespace(), eddystoneDevices,
        eddystoneDeviceEvent.getTimestamp());
  }
}
