package com.kontakt.sdk.android.ble.discovery;

/**
 * Interface representing Discovery contract.
 */
public interface DiscoveryContract {

  /**
   * Notifies that the scan has started.
   */
  void onMonitorCycleStart();

  /**
   * Notifires that the scan has stopped.
   */
  void onMonitorCycleStop();

  /**
   * Notifies about specific event occurence.
   *
   * @param event the event
   */
  void onEvent(BluetoothDeviceEvent event);
}
