package com.kontakt.sdk.android.ble.connection;

/**
 * Interface describing connection to the remote device.
 *
 * @param <T> the type parameter
 */
public interface RemoteKontaktDeviceConnection<T> {

  /**
   * sends connection request to the device.
   *
   * @return the boolean
   */
  boolean connect();

  /**
   * Closes connection to the device.
   */
  void close();

  /**
   * Provides information whether connection is established to the device.
   *
   * @return true if connection to the device is established
   */
  boolean isConnected();

  /**
   * Provides information whether the remote device has been authenticated.
   *
   * @return true if the remote device has been authenticated.
   */
  boolean isAuthenticated();

  /**
   * Provides information whether the connection to the remote device is established.
   *
   * @return the boolean
   */
  boolean isClosed();

  /**
   * Provides remote device that the connection is established with.
   *
   * @return the device
   */
  T getDevice();
}
