package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.exception.IllegalOperationException;
import com.kontakt.sdk.android.common.FirmwareRevisions;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

enum OperationWrite {
  CONFIG,
  PROFILE,
  MINOR,
  MAJOR,
  NON_CONNECTABLE_MODE,
  PROXIMITY_UUID,
  PASSWORD,
  MODEL_NAME,
  ADVERTISING_INTERVAL,
  POWER_LEVEL,
  DEVICE_PROFILE,
  RESET,
  DFU,
  URL,
  NAMESPACE,
  INSTANCE_ID,
  RESTORE,
  SECURE_CONFIG(true),
  SECURE_COMMAND(true);

  private boolean secure;

  OperationWrite(boolean secure) {
    this.secure = secure;
  }

  OperationWrite() {
    this.secure = false;
  }

  public void validate(RemoteBluetoothDevice remoteBluetoothDevice) {
    String firmwareVersion = remoteBluetoothDevice.getFirmwareVersion();
    if (!secure) {
      if (!FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(firmwareVersion)) {
        throw new IllegalOperationException("Operation unknown");
      }
    } else {
      boolean isInNormalMode = FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(firmwareVersion);
      boolean isInSecureMode = FirmwareRevisions.SECURE_MODE_FIRMWARE_VERSIONS.contains(firmwareVersion);

      if (!isInSecureMode) {
        if (isInNormalMode) {
          throw new IllegalOperationException("Operation not available");
        }
      }
    }
  }
}
