package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import java.util.Collection;
import java.util.List;
import java.util.Set;

interface GlobalScanContext {

  ForceScanConfiguration getForceScanConfiguration();

  ScanPeriod getScanPeriod();

  ScanMode getScanMode();

  ActivityCheckConfiguration getActivityCheckConfiguration();

  long getDevicesUpdateCallbackInterval();

  RssiCalculator getRssiCalculator();

  boolean isNonConnectableModeSupported();

  Set<DeviceProfile> getObservedProfiles();

  Collection<EddystoneFrameType> getEddystoneFrameTypes();

  Set<IBeaconRegion> getIBeaconRegions();

  Set<IEddystoneNamespace> getEddystoneNamespaces();

  List<IBeaconFilter> getIBeaconFilters();

  List<EddystoneFilter> getEddystoneFilters();
}
