/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class Firmware
implements Parcelable {
    public static final Parcelable.Creator<Firmware> CREATOR = new Parcelable.Creator<Firmware>(){

        public Firmware createFromParcel(Parcel source) {
            return new Firmware(source);
        }

        public Firmware[] newArray(int size) {
            return new Firmware[size];
        }
    };
    private UUID id;
    private String name;
    private String description;
    private String validVersions;
    private boolean important;
    private DeviceType deviceType;
    private boolean scheduled;
    private boolean optional;
    @SerializedName(value="uniqueId")
    private List<String> deviceUniqueIds;
    @SerializedName(value="url")
    private String fileUrl;

    public static Builder builder() {
        return new Builder();
    }

    private Firmware() {
        this(new Builder());
    }

    private Firmware(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.validVersions = builder.validVersions;
        this.important = builder.important;
        this.deviceType = builder.deviceType;
        this.scheduled = builder.scheduled;
        this.optional = builder.optional;
        this.deviceUniqueIds = builder.deviceUniqueIds;
        this.fileUrl = builder.fileUrl;
    }

    protected Firmware(Parcel in) {
        this.id = (UUID)in.readSerializable();
        this.name = in.readString();
        this.description = in.readString();
        this.validVersions = in.readString();
        this.important = in.readByte() != 0;
        int tmpDeviceType = in.readInt();
        this.deviceType = tmpDeviceType == -1 ? null : DeviceType.values()[tmpDeviceType];
        this.scheduled = in.readByte() != 0;
        this.optional = in.readByte() != 0;
        this.deviceUniqueIds = in.createStringArrayList();
        this.fileUrl = in.readString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Firmware)) {
            return false;
        }
        Firmware firmware = (Firmware)o;
        return SDKEqualsBuilder.start().equals(this.id, firmware.id).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.id).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.id);
        dest.writeString(this.name);
        dest.writeString(this.description);
        dest.writeString(this.validVersions);
        dest.writeByte(this.important ? (byte)1 : 0);
        dest.writeInt(this.deviceType == null ? -1 : this.deviceType.ordinal());
        dest.writeByte(this.scheduled ? (byte)1 : 0);
        dest.writeByte(this.optional ? (byte)1 : 0);
        dest.writeStringList(this.deviceUniqueIds);
        dest.writeString(this.fileUrl);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValidVersions() {
        return this.validVersions;
    }

    public boolean isImportant() {
        return this.important;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public List<String> getDeviceUniqueIds() {
        return this.deviceUniqueIds;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public static class Builder {
        private UUID id;
        private String name;
        private String description;
        private String validVersions;
        private boolean important;
        private DeviceType deviceType;
        private boolean scheduled;
        private boolean optional;
        private List<String> deviceUniqueIds;
        private String fileUrl;

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder validVersions(String validVersions) {
            this.validVersions = validVersions;
            return this;
        }

        public Builder important(boolean important) {
            this.important = important;
            return this;
        }

        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder scheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder devices(List<String> deviceUniqueIds) {
            this.deviceUniqueIds = deviceUniqueIds;
            return this;
        }

        public Builder fileUrl(String fileUrl) {
            this.fileUrl = fileUrl;
            return this;
        }

        public Firmware build() {
            return new Firmware(this);
        }
    }
}

