/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Event;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;

public class EventPacket
implements Parcelable {
    private long timestamp;
    private List<Event> events = new ArrayList<Event>();
    public static final Parcelable.Creator<EventPacket> CREATOR = new Parcelable.Creator<EventPacket>(){

        public EventPacket createFromParcel(Parcel source) {
            return new EventPacket(source);
        }

        public EventPacket[] newArray(int size) {
            return new EventPacket[size];
        }
    };

    public static EventPacket from(List<Event> events, long timestamp) {
        SDKPreconditions.checkNotNull(events, "events cannot be null");
        return new EventPacket(events, timestamp);
    }

    private EventPacket(List<Event> events, long timestamp) {
        this.events = events;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeList(this.events);
    }

    protected EventPacket(Parcel in) {
        this.timestamp = in.readLong();
        in.readList(this.events, Event.class.getClassLoader());
    }
}

