/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.EventType;
import com.kontakt.sdk.android.common.model.MonitoringEvent;
import com.kontakt.sdk.android.common.model.ScanEvent;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public abstract class Event
implements Parcelable {
    protected final EventType eventType;
    protected final long timestamp;
    protected final String uniqueId;

    protected Event(EventType eventType, long timestamp, String uniqueId) {
        this.eventType = eventType;
        this.timestamp = timestamp / 1000L;
        this.uniqueId = uniqueId;
    }

    protected Event(Parcel in) {
        int tmpEventType = in.readInt();
        this.eventType = tmpEventType == -1 ? null : EventType.values()[tmpEventType];
        this.timestamp = in.readLong();
        this.uniqueId = in.readString();
    }

    public static Event of(RemoteBluetoothDevice device, EventType eventType) {
        SDKPreconditions.checkNotNull(device, "device cannot be null");
        SDKPreconditions.checkNotNull(eventType, "event type cannot be null");
        switch (eventType) {
            case SCAN: {
                return new ScanEvent(eventType, device.getTimestamp(), device.getUniqueId(), device.getRssi());
            }
            case MONITORING: {
                return new MonitoringEvent(eventType, device.getTimestamp(), device.getUniqueId(), device.getBatteryPower());
            }
        }
        throw new IllegalArgumentException("invalid event type");
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.eventType == null ? -1 : this.eventType.ordinal());
        dest.writeLong(this.timestamp);
        dest.writeString(this.uniqueId);
    }

    public EventType getType() {
        return this.eventType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }
}

