/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class EddystoneUid
implements Parcelable {
    public static final Parcelable.Creator<EddystoneUid> CREATOR = new Parcelable.Creator<EddystoneUid>(){

        public EddystoneUid createFromParcel(Parcel source) {
            return new EddystoneUid(source);
        }

        public EddystoneUid[] newArray(int size) {
            return new EddystoneUid[size];
        }
    };
    private final String namespace;
    private final String instanceId;

    public static EddystoneUid of(String namespace, String instanceId) {
        return new EddystoneUid(namespace, instanceId);
    }

    public static EddystoneUid fromDevice(IEddystoneDevice fakeDevice) {
        SDKPreconditions.checkNotNull(fakeDevice, "device cannot be null");
        return new EddystoneUid(fakeDevice.getNamespaceId(), fakeDevice.getInstanceId());
    }

    public static EddystoneUid fromQueriedBy(String queriedBy) {
        SDKPreconditions.checkNotNull(queriedBy, "queriedBy is null");
        String[] split = queriedBy.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("queriedBy has invalid format");
        }
        String namespace = split[0];
        String instanceId = split[1];
        return new EddystoneUid(namespace, instanceId);
    }

    private EddystoneUid(String namespace, String instanceId) {
        this.namespace = namespace;
        this.instanceId = instanceId;
    }

    protected EddystoneUid(Parcel in) {
        this.namespace = in.readString();
        this.instanceId = in.readString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String toString() {
        return this.namespace + ":" + this.instanceId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EddystoneUid)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EddystoneUid eddystoneUid = (EddystoneUid)o;
        return SDKEqualsBuilder.start().equals(this.namespace, eddystoneUid.namespace).equals(this.instanceId, eddystoneUid.instanceId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.namespace).append(this.instanceId).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.namespace);
        dest.writeString(this.instanceId);
    }
}

