/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Credentials;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.EddystoneFutureUID;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.IBeaconFutureId;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.model.Shuffles;
import com.kontakt.sdk.android.common.model.Specification;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class Device
implements Parcelable {
    public static final Parcelable.Creator<Device> CREATOR = new Parcelable.Creator<Device>(){

        public Device createFromParcel(Parcel source) {
            return new Device(source);
        }

        public Device[] newArray(int size) {
            return new Device[size];
        }
    };
    private String uniqueId;
    private UUID id;
    @SerializedName(value="futureId")
    private Shuffles shuffles;
    private String mac;
    private UUID secureProximity;
    private String secureNamespace;
    private Config config;
    private String firmware;
    private String alias;
    private DeviceType deviceType;
    private Specification specification;
    private Model model;
    private UUID managerId;
    private Venue venue;
    private int actionsCount;
    private Access access;
    private String lat;
    private String lng;
    private String queriedBy;

    public static Builder builder() {
        return new Builder();
    }

    private Device() {
        this(new Builder());
    }

    private Device(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.id = builder.id;
        this.shuffles = builder.shuffles;
        this.mac = builder.mac;
        this.secureProximity = builder.secureProximity;
        this.secureNamespace = builder.secureNamespace;
        this.config = builder.config;
        this.firmware = builder.firmware;
        this.alias = builder.alias;
        this.deviceType = builder.deviceType;
        this.specification = builder.specification;
        this.model = builder.model;
        this.managerId = builder.managerId;
        this.venue = builder.venue;
        this.actionsCount = builder.actionsCount;
        this.access = builder.access;
        this.lat = builder.lat;
        this.lng = builder.lng;
        this.queriedBy = builder.queriedBy;
    }

    protected Device(Parcel in) {
        this.uniqueId = in.readString();
        this.id = (UUID)in.readSerializable();
        this.shuffles = (Shuffles)in.readParcelable(Shuffles.class.getClassLoader());
        this.mac = in.readString();
        this.secureProximity = (UUID)in.readSerializable();
        this.secureNamespace = in.readString();
        this.config = (Config)in.readParcelable(Config.class.getClassLoader());
        this.firmware = in.readString();
        this.alias = in.readString();
        int tmpDeviceType = in.readInt();
        this.deviceType = tmpDeviceType == -1 ? null : DeviceType.values()[tmpDeviceType];
        int tmpSpecification = in.readInt();
        this.specification = tmpSpecification == -1 ? null : Specification.values()[tmpSpecification];
        int tmpModel = in.readInt();
        this.model = tmpModel == -1 ? null : Model.values()[tmpModel];
        this.managerId = (UUID)in.readSerializable();
        this.venue = (Venue)in.readParcelable(Venue.class.getClassLoader());
        this.actionsCount = in.readInt();
        int tmpAccess = in.readInt();
        this.access = tmpAccess == -1 ? null : Access.values()[tmpAccess];
        this.lat = in.readString();
        this.lng = in.readString();
        this.queriedBy = in.readString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Device)) {
            return false;
        }
        Device device = (Device)o;
        return SDKEqualsBuilder.start().equals(this.uniqueId, device.uniqueId).equals(this.firmware, device.firmware).equals(this.alias, device.alias).equals(this.lat, device.lat).equals(this.lng, device.lng).equals(this.queriedBy, device.queriedBy).equals((Object)this.access, (Object)device.access).equals(this.venue, device.venue).equals(this.actionsCount, device.actionsCount).equals(this.id, device.id).equals((Object)this.deviceType, (Object)device.deviceType).equals(this.managerId, device.managerId).equals((Object)this.specification, (Object)device.specification).equals((Object)this.model, (Object)device.model).equals(this.mac, device.mac).equals(this.secureProximity, device.secureProximity).equals(this.secureNamespace, device.secureNamespace).equals(this.shuffles, device.shuffles).equals(this.config, device.config).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.uniqueId).append(this.firmware).append(this.alias).append(this.lat).append(this.lng).append(this.queriedBy).append((Object)this.access).append(this.venue).append(this.actionsCount).append(this.id).append((Object)this.deviceType).append(this.managerId).append((Object)this.specification).append((Object)this.model).append(this.mac).append(this.secureProximity).append(this.secureNamespace).append(this.shuffles).append(this.config).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uniqueId);
        dest.writeSerializable((Serializable)this.id);
        dest.writeParcelable((Parcelable)this.shuffles, flags);
        dest.writeString(this.mac);
        dest.writeSerializable((Serializable)this.secureProximity);
        dest.writeString(this.secureNamespace);
        dest.writeParcelable((Parcelable)this.config, flags);
        dest.writeString(this.firmware);
        dest.writeString(this.alias);
        dest.writeInt(this.deviceType == null ? -1 : this.deviceType.ordinal());
        dest.writeInt(this.specification == null ? -1 : this.specification.ordinal());
        dest.writeInt(this.model == null ? -1 : this.model.ordinal());
        dest.writeSerializable((Serializable)this.managerId);
        dest.writeParcelable((Parcelable)this.venue, flags);
        dest.writeInt(this.actionsCount);
        dest.writeInt(this.access == null ? -1 : this.access.ordinal());
        dest.writeString(this.lat);
        dest.writeString(this.lng);
        dest.writeString(this.queriedBy);
    }

    public void applyConfig(Config config) {
        this.config.applyConfig(config);
    }

    public void applySecureConfig(Config secureConfig) {
        this.config.applySecureConfig(secureConfig);
    }

    public void applyCredentials(Credentials credentials) {
        SDKPreconditions.checkNotNull(credentials, "credentials cannot be null");
        this.config.changePassword(credentials.getPassword());
    }

    public IBeaconFutureId extractIBeaconFutureId() {
        if (this.shuffles == null || !this.config.getProfiles().contains((Object)DeviceProfile.IBEACON)) {
            return null;
        }
        UUID proximity = this.config.getProximity();
        int major = this.config.getMajor();
        int minor = this.config.getMinor();
        IBeaconId resolved = IBeaconId.of(proximity, major, minor);
        return new IBeaconFutureId.Builder().uniqueId(this.uniqueId).queriedBy(this.queriedBy != null ? IBeaconId.fromQueriedBy(this.queriedBy) : null).resolved(resolved).futureIds(this.shuffles.getIBeaconShuffles()).build();
    }

    public EddystoneFutureUID extractEddystoneFutureUID() {
        if (this.shuffles == null || !this.config.getProfiles().contains((Object)DeviceProfile.EDDYSTONE)) {
            return null;
        }
        String namespace = this.config.getNamespace();
        String instanceId = this.config.getInstanceId();
        EddystoneUid resolved = EddystoneUid.of(namespace, instanceId);
        return new EddystoneFutureUID.Builder().uniqueId(this.uniqueId).queriedBy(this.queriedBy != null ? EddystoneUid.fromQueriedBy(this.queriedBy) : null).resolved(resolved).futureIds(this.shuffles.getEddystoneShuffles()).build();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public UUID getId() {
        return this.id;
    }

    public Shuffles getShuffles() {
        return this.shuffles;
    }

    public String getMac() {
        return this.mac;
    }

    public UUID getSecureProximity() {
        return this.secureProximity;
    }

    public String getSecureNamespace() {
        return this.secureNamespace;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getFirmware() {
        return this.firmware;
    }

    public String getAlias() {
        return this.alias;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public Model getModel() {
        return this.model;
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public int getActionsCount() {
        return this.actionsCount;
    }

    public Access getAccess() {
        return this.access;
    }

    public String getLatitude() {
        return this.lat;
    }

    public String getLongitude() {
        return this.lng;
    }

    public String getQueriedBy() {
        return this.queriedBy;
    }

    public static class Builder {
        private String uniqueId;
        private UUID id;
        private Shuffles shuffles;
        private String mac;
        private UUID secureProximity;
        private String secureNamespace;
        private Config config;
        private String firmware;
        private String alias;
        private DeviceType deviceType;
        private Specification specification;
        private Model model;
        private UUID managerId;
        private Venue venue;
        private int actionsCount;
        private Access access;
        private String lat;
        private String lng;
        private String queriedBy;

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder shuffles(Shuffles shuffles) {
            this.shuffles = shuffles;
            return this;
        }

        public Builder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public Builder secureProximity(UUID secureProximity) {
            this.secureProximity = secureProximity;
            return this;
        }

        public Builder secureNamespace(String secureNamespace) {
            this.secureNamespace = secureNamespace;
            return this;
        }

        public Builder config(Config config) {
            this.config = SDKPreconditions.checkNotNull(config, "config cannot be null");
            return this;
        }

        public Builder firmware(String firmware) {
            this.firmware = firmware;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder specification(Specification specification) {
            this.specification = specification;
            return this;
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder managerId(UUID managerId) {
            this.managerId = managerId;
            return this;
        }

        public Builder venue(Venue venue) {
            this.venue = venue;
            return this;
        }

        public Builder actionsCount(int actionsCount) {
            SDKPreconditions.checkState(actionsCount >= 0, "actions count cannot be negative");
            this.actionsCount = actionsCount;
            return this;
        }

        public Builder access(Access access) {
            this.access = access;
            return this;
        }

        public Builder latitude(String lat) {
            this.lat = lat;
            return this;
        }

        public Builder longitude(String lng) {
            this.lng = lng;
            return this;
        }

        public Builder queriedBy(String queriedBy) {
            this.queriedBy = queriedBy;
            return this;
        }

        public Device build() {
            return new Device(this);
        }
    }
}

